/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.version;

import com.fasterxml.jackson.databind.DeserializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.eclipse.edc.connector.api.management.version.v1.VersionApiController;
import org.eclipse.edc.runtime.metamodel.annotation.Configuration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.Settings;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.apiversion.ApiVersionService;
import org.eclipse.edc.spi.system.apiversion.VersionRecord;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.PortMapping;
import org.eclipse.edc.web.spi.configuration.PortMappingRegistry;

@Extension(value="Management API: Version Information")
public class VersionApiExtension
implements ServiceExtension {
    public static final String NAME = "Management API: Version Information";
    private static final String DEFAULT_VERSION_PATH = "/.well-known/api";
    private static final int DEFAULT_VERSION_PORT = 7171;
    private static final String API_VERSION_JSON_FILE = "version-api-version.json";
    @Configuration
    private VersionApiConfiguration apiConfiguration;
    @Inject
    private WebService webService;
    @Inject
    private TypeManager typeManager;
    @Inject
    private ApiVersionService apiVersionService;
    @Inject
    private PortMappingRegistry portMappingRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        PortMapping portMapping = new PortMapping("version", this.apiConfiguration.port(), this.apiConfiguration.path());
        this.portMappingRegistry.register(portMapping);
        this.webService.registerResource("version", (Object)new VersionApiController(this.apiVersionService));
        this.registerVersionInfo(this.getClass().getClassLoader());
    }

    private void registerVersionInfo(ClassLoader resourceClassLoader) {
        try (InputStream versionContent = resourceClassLoader.getResourceAsStream(API_VERSION_JSON_FILE);){
            if (versionContent == null) {
                throw new EdcException("Version file not found or not readable.");
            }
            Stream.of((VersionRecord[])this.typeManager.getMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(versionContent, VersionRecord[].class)).forEach(vr -> this.apiVersionService.addRecord("version", vr));
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    @Settings
    record VersionApiConfiguration(@Setting(key="web.http.version.port", description="Port for version api context", defaultValue="7171") int port, @Setting(key="web.http.version.path", description="Path for version api context", defaultValue="/.well-known/api") String path) {
    }
}

