/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.edc.identityhub.api.verifiablecredential.validation.VerifiableCredentialManifestValidator;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.VerifiableCredentialsApi;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.model.CredentialDescriptor;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.model.CredentialRequestDto;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.model.HolderCredentialRequestDto;
import org.eclipse.edc.identityhub.spi.authorization.AuthorizationResultHandler;
import org.eclipse.edc.identityhub.spi.authorization.AuthorizationService;
import org.eclipse.edc.identityhub.spi.credential.request.model.HolderCredentialRequest;
import org.eclipse.edc.identityhub.spi.participantcontext.ParticipantContextId;
import org.eclipse.edc.identityhub.spi.participantcontext.model.ParticipantContext;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.CredentialRequestManager;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.model.VerifiableCredentialManifest;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.model.VerifiableCredentialResource;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.store.CredentialStore;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.ServiceFailure;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.util.string.StringUtils;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectConflictException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;
import org.jetbrains.annotations.Nullable;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v1alpha/participants/{participantContextId}/credentials")
public class VerifiableCredentialsApiController
implements VerifiableCredentialsApi {
    private final CredentialStore credentialStore;
    private final AuthorizationService authorizationService;
    private final VerifiableCredentialManifestValidator validator;
    private final TypeTransformerRegistry typeTransformerRegistry;
    private final CredentialRequestManager credentialRequestService;

    public VerifiableCredentialsApiController(CredentialStore credentialStore, AuthorizationService authorizationService, VerifiableCredentialManifestValidator validator, TypeTransformerRegistry typeTransformerRegistry, CredentialRequestManager credentialRequestService) {
        this.credentialStore = credentialStore;
        this.authorizationService = authorizationService;
        this.validator = validator;
        this.typeTransformerRegistry = typeTransformerRegistry;
        this.credentialRequestService = credentialRequestService;
    }

    @Override
    @GET
    @Path(value="/{credentialId}")
    public VerifiableCredentialResource getCredential(@PathParam(value="credentialId") String id, @Context SecurityContext securityContext) {
        this.authorizationService.isAuthorized(securityContext, id, VerifiableCredentialResource.class).orElseThrow(AuthorizationResultHandler.exceptionMapper(VerifiableCredentialResource.class, (String)id));
        Collection result = (Collection)this.credentialStore.query(QuerySpec.Builder.newInstance().filter(new Criterion((Object)"id", "=", (Object)id)).build()).orElseThrow(InvalidRequestException::new);
        return (VerifiableCredentialResource)result.stream().findFirst().orElseThrow(() -> new ObjectNotFoundException(VerifiableCredentialResource.class, id));
    }

    @Override
    @POST
    public void addCredential(@PathParam(value="participantContextId") String participantId, VerifiableCredentialManifest manifest, @Context SecurityContext securityContext) {
        this.validator.validate(manifest).orElseThrow(ValidationFailureException::new);
        String decoded = (String)ParticipantContextId.onEncoded((String)participantId).orElseThrow(InvalidRequestException::new);
        ((ServiceResult)((ServiceResult)this.authorizationService.isAuthorized(securityContext, decoded, ParticipantContext.class).compose(u -> (ServiceResult)this.typeTransformerRegistry.transform((Object)manifest, VerifiableCredentialResource.class).map(ServiceResult::success).orElse(failure -> ServiceResult.badRequest((String[])new String[]{failure.getFailureDetail()})))).compose(vcr -> ServiceResult.from((StoreResult)this.credentialStore.create(vcr)))).orElseThrow(AuthorizationResultHandler.exceptionMapper(VerifiableCredentialResource.class));
    }

    @Override
    @PUT
    public void updateCredential(VerifiableCredentialManifest manifest, @Context SecurityContext securityContext) {
        this.validator.validate(manifest).orElseThrow(ValidationFailureException::new);
        ((ServiceResult)((ServiceResult)this.authorizationService.isAuthorized(securityContext, manifest.getId(), VerifiableCredentialResource.class).compose(u -> (ServiceResult)this.typeTransformerRegistry.transform((Object)manifest, VerifiableCredentialResource.class).map(ServiceResult::success).orElse(failure -> ServiceResult.badRequest((String[])new String[]{failure.getFailureDetail()})))).compose(vcr -> ServiceResult.from((StoreResult)this.credentialStore.update(vcr)))).orElseThrow(AuthorizationResultHandler.exceptionMapper(VerifiableCredentialResource.class));
    }

    @Override
    @GET
    public Collection<VerifiableCredentialResource> queryCredentialsByType(@QueryParam(value="type") @Nullable String type, @Context SecurityContext securityContext) {
        QuerySpec.Builder query = QuerySpec.Builder.newInstance();
        if (!StringUtils.isNullOrEmpty((String)type)) {
            query.filter(new Criterion((Object)"verifiableCredential.credential.type", "contains", (Object)type));
        }
        return ((Collection)this.credentialStore.query(query.build()).orElseThrow(InvalidRequestException::new)).stream().filter(vcr -> this.authorizationService.isAuthorized(securityContext, vcr.getId(), VerifiableCredentialResource.class).succeeded()).toList();
    }

    @Override
    @DELETE
    @Path(value="/{credentialId}")
    public void deleteCredential(@PathParam(value="credentialId") String id, @Context SecurityContext securityContext) {
        this.authorizationService.isAuthorized(securityContext, id, VerifiableCredentialResource.class).orElseThrow(AuthorizationResultHandler.exceptionMapper(VerifiableCredentialResource.class, (String)id));
        StoreResult res = this.credentialStore.deleteById(id);
        if (res.failed()) {
            throw (EdcException)AuthorizationResultHandler.exceptionMapper(VerifiableCredentialResource.class, (String)id).apply((ServiceFailure)ServiceResult.fromFailure((StoreResult)res).getFailure());
        }
    }

    @Override
    @POST
    @Path(value="/request")
    public Response requestCredential(@PathParam(value="participantContextId") String participantContextId, CredentialRequestDto credentialRequestDto, @Context SecurityContext securityContext) {
        String participantId = (String)ParticipantContextId.onEncoded((String)participantContextId).orElseThrow(InvalidRequestException::new);
        this.authorizationService.isAuthorized(securityContext, participantId, ParticipantContext.class).orElseThrow(AuthorizationResultHandler.exceptionMapper(ParticipantContext.class, (String)participantId));
        Optional<String> holderPid = Optional.ofNullable(credentialRequestDto.holderPid());
        Map<String, String> requestParameters = credentialRequestDto.credentials().stream().collect(Collectors.toMap(CredentialDescriptor::credentialType, CredentialDescriptor::format));
        ServiceResult credentialRequestResult = this.credentialRequestService.initiateRequest(participantId, credentialRequestDto.issuerDid(), holderPid.orElseGet(() -> UUID.randomUUID().toString()), requestParameters);
        return (Response)credentialRequestResult.map(id -> Response.status((int)201).entity(id).build()).orElseThrow(sf -> {
            if (sf.getReason().equals((Object)ServiceFailure.Reason.CONFLICT)) {
                throw new ObjectConflictException(sf.getFailureDetail());
            }
            throw new InvalidRequestException(sf.getMessages());
        });
    }

    @Override
    @GET
    @Path(value="/request/{holderPid}")
    public HolderCredentialRequestDto getCredentialRequest(@PathParam(value="participantContextId") String participantContextId, @PathParam(value="holderPid") String holderPid, @Context SecurityContext securityContext) {
        String participantId = (String)ParticipantContextId.onEncoded((String)participantContextId).orElseThrow(InvalidRequestException::new);
        this.authorizationService.isAuthorized(securityContext, participantId, ParticipantContext.class).orElseThrow(AuthorizationResultHandler.exceptionMapper(ParticipantContext.class, (String)participantId));
        return Optional.ofNullable(this.credentialRequestService.findById(holderPid)).map(req -> new HolderCredentialRequestDto(req.getIssuerDid(), req.getHolderPid(), req.getIssuerPid(), req.stateAsString(), req.getTypesAndFormats())).orElseThrow(() -> new ObjectNotFoundException(HolderCredentialRequest.class, holderPid));
    }
}

