/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Collection;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.model.CredentialRequestDto;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.model.HolderCredentialRequestDto;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.model.VerifiableCredentialManifest;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.model.VerifiableCredentialResource;
import org.eclipse.edc.web.spi.ApiErrorDetail;

@OpenAPIDefinition(info=@Info(description="This is the Identity API for manipulating VerifiableCredentials", title="VerifiableCredentials Identity API", version="1"))
@Tag(name="Verifiable Credentials")
public interface VerifiableCredentialsApi {
    @Operation(description="Finds a VerifiableCredential by ID.", operationId="getCredential", parameters={@Parameter(name="participantContextId", description="Base64-Url encode Participant Context ID", required=true, in=ParameterIn.PATH)}, responses={@ApiResponse(responseCode="200", description="The VerifiableCredential.", content={@Content(schema=@Schema(implementation=VerifiableCredentialResource.class))}), @ApiResponse(responseCode="400", description="Request body was malformed, or the request could not be processed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="403", description="The request could not be completed, because either the authentication was missing or was not valid.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="404", description="A VerifiableCredential with the given ID does not exist.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")})})
    public VerifiableCredentialResource getCredential(String var1, SecurityContext var2);

    @Operation(description="Adds a new VerifiableCredential into the system.", operationId="addCredential", parameters={@Parameter(name="participantContextId", description="Base64-Url encode Participant Context ID", required=true, in=ParameterIn.PATH)}, requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=VerifiableCredentialManifest.class))}), responses={@ApiResponse(responseCode="204", description="The VerifiableCredential was successfully created."), @ApiResponse(responseCode="400", description="Request body was malformed, or the request could not be processed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="403", description="The request could not be completed, because either the authentication was missing or was not valid.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="409", description="Could not create VerifiableCredential, because a VerifiableCredential with that ID already exists", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")})})
    public void addCredential(String var1, VerifiableCredentialManifest var2, SecurityContext var3);

    @Operation(description="Update an existing VerifiableCredential.", operationId="updateCredential", parameters={@Parameter(name="participantContextId", description="Base64-Url encode Participant Context ID", required=true, in=ParameterIn.PATH)}, requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=VerifiableCredentialManifest.class))}), responses={@ApiResponse(responseCode="204", description="The VerifiableCredential was updated successfully."), @ApiResponse(responseCode="400", description="Request body was malformed, or the request could not be processed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="403", description="The request could not be completed, because either the authentication was missing or was not valid.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="404", description="VerifiableCredential could not be updated because it does not exist.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")})})
    public void updateCredential(VerifiableCredentialManifest var1, SecurityContext var2);

    @Operation(description="Query VerifiableCredentials by type.", operationId="queryCredentialsByType", parameters={@Parameter(name="participantContextId", description="Base64-Url encode Participant Context ID", required=true, in=ParameterIn.PATH), @Parameter(name="type", description="Credential type. If omitted, all credentials are returned (limited to 50 elements).")}, responses={@ApiResponse(responseCode="200", description="The list of VerifiableCredentials.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=VerifiableCredentialResource.class)))}), @ApiResponse(responseCode="403", description="The request could not be completed, because either the authentication was missing or was not valid.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="400", description="The query was malformed or was not understood by the server.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")})})
    public Collection<VerifiableCredentialResource> queryCredentialsByType(String var1, SecurityContext var2);

    @Operation(description="Delete a VerifiableCredential.", operationId="deleteCredential", parameters={@Parameter(name="participantContextId", description="Base64-Url encode Participant Context ID", required=true, in=ParameterIn.PATH)}, responses={@ApiResponse(responseCode="200", description="The VerifiableCredential was deleted successfully", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Request body was malformed, or the request could not be processed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="403", description="The request could not be completed, because either the authentication was missing or was not valid.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="404", description="A VerifiableCredential with the given ID does not exist.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")})})
    public void deleteCredential(String var1, SecurityContext var2);

    @Operation(description="Triggers a credential request that is send to the issuer via the DCP protocol.", operationId="requestCredential", parameters={@Parameter(name="participantContextId", description="Base64-Url encode Participant Context ID", required=true, in=ParameterIn.PATH)}, requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=CredentialRequestDto.class))}), responses={@ApiResponse(responseCode="201", description="The request was processed and sent to the issuer. The issuer-created ID (\"issuerPid\") is returned in the response.", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Request body was malformed, or the request could not be processed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="403", description="The request could not be completed, because either the authentication was missing or was not valid.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="409", description="Could not create a credential request, because a credential request with that ID already exists", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")})})
    public Response requestCredential(String var1, CredentialRequestDto var2, SecurityContext var3);

    @Operation(description="Finds a credential request by ID.", operationId="getCredentialRequest", parameters={@Parameter(name="participantContextId", description="Base64-Url encode Participant Context ID", required=true, in=ParameterIn.PATH), @Parameter(name="issuerPid", description="The issuer-assigned ID of the issuance process", required=true, in=ParameterIn.PATH)}, responses={@ApiResponse(responseCode="200", description="The VerifiableCredential.", content={@Content(schema=@Schema(implementation=VerifiableCredentialResource.class))}), @ApiResponse(responseCode="400", description="Request body was malformed, or the request could not be processed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="403", description="The request could not be completed, because either the authentication was missing or was not valid.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")}), @ApiResponse(responseCode="404", description="A VerifiableCredential with the given ID does not exist.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiErrorDetail.class)), mediaType="application/json")})})
    public HolderCredentialRequestDto getCredentialRequest(String var1, String var2, SecurityContext var3);
}

