/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable;

import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.GetAllCredentialsApi;
import org.eclipse.edc.identityhub.spi.authorization.AuthorizationResultHandler;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.model.VerifiableCredentialResource;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.store.CredentialStore;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.result.StoreResult;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v1alpha/credentials")
public class GetAllCredentialsApiController
implements GetAllCredentialsApi {
    private final CredentialStore credentialStore;

    public GetAllCredentialsApiController(CredentialStore credentialStore) {
        this.credentialStore = credentialStore;
    }

    @Override
    @GET
    @RolesAllowed(value={"admin"})
    public Collection<VerifiableCredentialResource> getAllCredentials(@DefaultValue(value="0") @QueryParam(value="offset") Integer offset, @DefaultValue(value="50") @QueryParam(value="limit") Integer limit) {
        StoreResult res = this.credentialStore.query(QuerySpec.Builder.newInstance().limit(limit).offset(offset).build());
        return (Collection)ServiceResult.from((StoreResult)res).orElseThrow(AuthorizationResultHandler.exceptionMapper(VerifiableCredentialResource.class));
    }
}

