/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api.verifiablecredentials;

import org.eclipse.edc.identityhub.api.verifiablecredential.validation.VerifiableCredentialManifestValidator;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.GetAllCredentialsApiController;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.VerifiableCredentialsApiController;
import org.eclipse.edc.identityhub.api.verifiablecredentials.v1.unstable.transformer.VerifiableCredentialManifestToVerifiableCredentialResourceTransformer;
import org.eclipse.edc.identityhub.spi.authorization.AuthorizationService;
import org.eclipse.edc.identityhub.spi.participantcontext.model.AbstractParticipantResource;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.CredentialRequestManager;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.model.VerifiableCredentialResource;
import org.eclipse.edc.identityhub.spi.verifiablecredentials.store.CredentialStore;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="VerifiableCredentials API Extension")
public class VerifiableCredentialApiExtension
implements ServiceExtension {
    public static final String NAME = "VerifiableCredentials API Extension";
    @Inject
    TypeTransformerRegistry typeTransformerRegistry;
    @Inject
    private WebService webService;
    @Inject
    private CredentialStore credentialStore;
    @Inject
    private AuthorizationService authorizationService;
    @Inject
    private CredentialRequestManager credentialRequestManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.authorizationService.addLookupFunction(VerifiableCredentialResource.class, this::queryById);
        TypeTransformerRegistry registry = this.typeTransformerRegistry.forContext("identity-api");
        registry.register((TypeTransformer)new VerifiableCredentialManifestToVerifiableCredentialResourceTransformer());
        VerifiableCredentialsApiController controller = new VerifiableCredentialsApiController(this.credentialStore, this.authorizationService, new VerifiableCredentialManifestValidator(), registry, this.credentialRequestManager);
        GetAllCredentialsApiController getAllController = new GetAllCredentialsApiController(this.credentialStore);
        this.webService.registerResource("identity", (Object)controller);
        this.webService.registerResource("identity", (Object)getAllController);
    }

    private AbstractParticipantResource queryById(String credentialId) {
        return (AbstractParticipantResource)this.credentialStore.query(QuerySpec.Builder.newInstance().filter(new Criterion((Object)"id", "=", (Object)credentialId)).build()).map(list -> (VerifiableCredentialResource)list.iterator().next()).orElseThrow(f -> new EdcException(f.getFailureDetail()));
    }
}

