/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject.validators;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;

public class MissingPrefixes
implements Validator<JsonObject> {
    private final JsonLdPath path;
    private final Supplier<Set<String>> prefixesSupplier;

    public MissingPrefixes(JsonLdPath path, Supplier<Set<String>> prefixesSupplier) {
        this.path = path;
        this.prefixesSupplier = prefixesSupplier;
    }

    public ValidationResult validate(JsonObject input) {
        Set<String> prefixes = this.prefixesSupplier.get();
        return Optional.ofNullable(input.getJsonArray(this.path.last())).filter(it -> !it.isEmpty()).map(it -> it.getJsonObject(0)).or(() -> Optional.of(input)).map(it -> this.validateObject((JsonObject)it, this.path, prefixes)).orElseGet(ValidationResult::success);
    }

    private ValidationResult validateObject(JsonObject input, JsonLdPath path, Set<String> prefixes) {
        return input.entrySet().stream().map(entry -> this.validateField((String)entry.getKey(), (JsonValue)entry.getValue(), path, prefixes)).reduce(ValidationResult::merge).orElse(ValidationResult.success());
    }

    private ValidationResult validateArray(JsonArray array, JsonLdPath path, Set<String> prefixes) {
        return array.stream().filter(f -> f instanceof JsonObject).map(JsonObject.class::cast).map(object -> this.validateObject((JsonObject)object, path, prefixes)).reduce(ValidationResult::merge).orElse(ValidationResult.success());
    }

    private ValidationResult validateField(String name, JsonValue value, JsonLdPath path, Set<String> prefixes) {
        return switch (name) {
            case "@type" -> this.validateTypeValue(value, path, prefixes);
            case "@id" -> this.validateIdValue(value, path, prefixes);
            default -> this.validateGenericField(name, value, path, prefixes);
        };
    }

    private ValidationResult validateTypeValue(JsonValue value, JsonLdPath path, Set<String> prefixes) {
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            return array.stream().filter(it -> it.getValueType() == JsonValue.ValueType.STRING).map(JsonString.class::cast).map(JsonString::getString).map(type -> this.validateType((String)type, path, prefixes)).reduce(ValidationResult::merge).orElseGet(ValidationResult::success);
        }
        if (value instanceof JsonString) {
            JsonString type2 = (JsonString)value;
            return this.validateType(type2.getString(), path, prefixes);
        }
        return ValidationResult.success();
    }

    private ValidationResult validateType(String type, JsonLdPath path, Set<String> prefixes) {
        String msg = "Value of @type contains a prefix '%s' which was not expended correctly. Ensure to attach the namespace definition in the input JSON-LD.";
        return this.validate(type, path, prefixes, xva$0 -> msg.formatted(xva$0));
    }

    private ValidationResult validate(String input, JsonLdPath path, Set<String> prefixes, Function<String, String> formatter) {
        return Arrays.stream(input.split(":")).findFirst().map(prefix -> this.validatePrefix((String)prefix, path, prefixes, formatter)).orElseGet(ValidationResult::success);
    }

    private ValidationResult validatePrefix(String prefix, JsonLdPath path, Set<String> prefixes, Function<String, String> formatter) {
        if (prefixes.contains(prefix)) {
            String msg = formatter.apply(prefix);
            return ValidationResult.failure((Violation)Violation.violation((String)msg, (String)path.toString()));
        }
        return ValidationResult.success();
    }

    private ValidationResult validateId(String id, JsonLdPath path, Set<String> prefixes) {
        String msg = "Value of @id contains a prefix '%s' which was not expended correctly. Ensure to attach the namespace definition in the input JSON-LD.";
        return this.validate(id, path, prefixes, xva$0 -> msg.formatted(xva$0));
    }

    private ValidationResult validateIdValue(JsonValue value, JsonLdPath path, Set<String> prefixes) {
        if (value instanceof JsonString) {
            JsonString id = (JsonString)value;
            return this.validateId(id.getString(), path, prefixes);
        }
        return ValidationResult.success();
    }

    private ValidationResult validateGenericField(String name, JsonValue value, JsonLdPath path, Set<String> prefixes) {
        String msg;
        JsonLdPath newPath = path.append(name);
        ValidationResult result = this.validate(name, newPath, prefixes, arg_0 -> MissingPrefixes.lambda$validateGenericField$12(msg = "Property %s, contains a prefix '%s' which was not expended correctly. Ensure to attach the namespace definition in the input JSON-LD.", name, arg_0));
        if (result.failed()) {
            return result;
        }
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            return this.validateObject(object, newPath, prefixes);
        }
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            return this.validateArray(array, newPath, prefixes);
        }
        return ValidationResult.success();
    }

    private static /* synthetic */ String lambda$validateGenericField$12(String msg, String name, String prefix) {
        return msg.formatted(name, prefix);
    }
}

