/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject.validators;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;

public class MandatoryArray
implements Validator<JsonObject> {
    private final JsonLdPath path;
    private final Integer min;

    public MandatoryArray(JsonLdPath path) {
        this(path, null);
    }

    public MandatoryArray(JsonLdPath path, Integer min) {
        this.path = path;
        this.min = min;
    }

    public static Function<JsonLdPath, Validator<JsonObject>> min(Integer min) {
        return path -> new MandatoryArray((JsonLdPath)path, min);
    }

    public ValidationResult validate(JsonObject input) {
        return Optional.ofNullable(input.getJsonArray(this.path.last())).map(this::validateMin).orElseGet(() -> ValidationResult.failure((Violation)Violation.violation((String)String.format("mandatory array '%s' is missing", this.path), (String)this.path.toString())));
    }

    private ValidationResult validateMin(JsonArray array) {
        if (this.min == null || array.size() >= this.min) {
            return ValidationResult.success();
        }
        return ValidationResult.failure((Violation)Violation.violation((String)String.format("array '%s' should at least contains '%s' elements", this.path, this.min), (String)this.path.toString()));
    }
}

