/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject.validators.model;

import jakarta.json.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.query.SortOrder;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.jsonobject.JsonObjectValidator;
import org.eclipse.edc.validator.jsonobject.validators.model.CriterionValidator;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;

public class QuerySpecValidator {
    public static Validator<JsonObject> instance(CriterionOperatorRegistry criterionOperatorRegistry) {
        return QuerySpecValidator.instance(JsonObjectValidator.newValidator(), criterionOperatorRegistry).build();
    }

    public static JsonObjectValidator.Builder instance(JsonObjectValidator.Builder builder, CriterionOperatorRegistry criterionOperatorRegistry) {
        return builder.verify("https://w3id.org/edc/v0.0.1/ns/offset", OptionalValueGreaterEqualZero::new).verify("https://w3id.org/edc/v0.0.1/ns/limit", OptionalValueGreaterZero::new).verify("https://w3id.org/edc/v0.0.1/ns/sortOrder", OptionalValueSortField::new).verify("https://w3id.org/edc/v0.0.1/ns/sortField", OptionalValueNotBlank::new).verifyArrayItem("https://w3id.org/edc/v0.0.1/ns/filterExpression", path -> CriterionValidator.instance(path, criterionOperatorRegistry));
    }

    private record OptionalValueNotBlank(JsonLdPath path) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            Optional<String> optional = Optional.ofNullable(input.getJsonArray(this.path.last())).map(it -> it.getJsonObject(0)).map(it -> it.getString("@value"));
            if (optional.isEmpty()) {
                return ValidationResult.success();
            }
            return optional.filter(it -> !it.isBlank()).map(it -> ValidationResult.success()).orElseGet(() -> ValidationResult.failure((Violation)Violation.violation((String)String.format("optional value '%s' is blank", this.path), (String)this.path.toString())));
        }
    }

    private record OptionalValueSortField(JsonLdPath path) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            List values = Optional.ofNullable(input.getJsonArray(this.path.last())).map(array -> array.stream().map(it -> it.asJsonObject().getString("@value")).toList()).orElse(Collections.emptyList());
            if (values.size() > 0 && !Arrays.stream(SortOrder.values()).map(Enum::name).toList().contains(values.get(0))) {
                String message = String.format("optional value '%s' must be one of %s", this.path, Arrays.toString(SortOrder.values()));
                return ValidationResult.failure((Violation)Violation.violation((String)message, (String)this.path.toString(), values.get(0)));
            }
            return ValidationResult.success();
        }
    }

    private record OptionalValueGreaterZero(JsonLdPath path) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            Integer value = Optional.ofNullable(input.getJsonArray(this.path.last())).map(it -> it.getJsonObject(0)).map(it -> it.getInt("@value")).orElse(1);
            if (value < 1) {
                return ValidationResult.failure((Violation)Violation.violation((String)String.format("optional value '%s' must be greater than zero", this.path), (String)this.path.toString(), (Object)value));
            }
            return ValidationResult.success();
        }
    }

    private record OptionalValueGreaterEqualZero(JsonLdPath path) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            Integer value = Optional.ofNullable(input.getJsonArray(this.path.last())).map(it -> it.getJsonObject(0)).map(it -> it.getInt("@value")).orElse(0);
            if (value < 0) {
                return ValidationResult.failure((Violation)Violation.violation((String)String.format("optional value '%s' must be greater or equal to zero", this.path), (String)this.path.toString(), (Object)value));
            }
            return ValidationResult.success();
        }
    }
}

