/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject.validators.model;

import jakarta.json.JsonObject;
import java.util.Optional;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.jsonobject.JsonObjectValidator;
import org.eclipse.edc.validator.jsonobject.validators.MandatoryArray;
import org.eclipse.edc.validator.jsonobject.validators.MandatoryValue;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;
import org.jetbrains.annotations.Nullable;

public class CriterionValidator {
    public static Validator<JsonObject> instance(CriterionOperatorRegistry criterionOperatorRegistry) {
        return CriterionValidator.instance(JsonObjectValidator.newValidator(), criterionOperatorRegistry).build();
    }

    public static JsonObjectValidator.Builder instance(JsonObjectValidator.Builder builder, CriterionOperatorRegistry criterionOperatorRegistry) {
        return builder.verify("https://w3id.org/edc/v0.0.1/ns/operandLeft", MandatoryValue::new).verify("https://w3id.org/edc/v0.0.1/ns/operator", MandatoryValue::new).verify("https://w3id.org/edc/v0.0.1/ns/operator", path -> new OperatorValidator((JsonLdPath)path, criterionOperatorRegistry)).verify("https://w3id.org/edc/v0.0.1/ns/operandRight", MandatoryArray.min(1)).verify(OperandRightValidator::new);
    }

    @Nullable
    private static String getOperator(JsonObject input) {
        return Optional.ofNullable(input.getJsonArray("https://w3id.org/edc/v0.0.1/ns/operator")).map(it -> it.getJsonObject(0)).map(it -> it.getString("@value")).orElse(null);
    }

    private record OperatorValidator(JsonLdPath path, CriterionOperatorRegistry criterionOperatorRegistry) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            String operator = CriterionValidator.getOperator(input);
            if (operator == null || this.criterionOperatorRegistry.isSupported(operator)) {
                return ValidationResult.success();
            }
            return ValidationResult.failure((Violation)Violation.violation((String)"Operator %s is not supported".formatted(operator), (String)this.path.toString(), (Object)operator));
        }
    }

    private record OperandRightValidator(JsonLdPath path) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            String operator = CriterionValidator.getOperator(input);
            if (operator == null || "in".equals(operator)) {
                return ValidationResult.success();
            }
            return Optional.ofNullable(input.getJsonArray("https://w3id.org/edc/v0.0.1/ns/operandRight")).filter(it -> it.size() < 2).map(it -> ValidationResult.success()).orElse(ValidationResult.failure((Violation)Violation.violation((String)String.format("%s cannot contain multiple values as the operator is not 'in'", this.path.append("https://w3id.org/edc/v0.0.1/ns/operandRight")), (String)"https://w3id.org/edc/v0.0.1/ns/operandRight")));
        }
    }
}

