/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject.validators;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;

public class TypeIs
implements Validator<JsonObject> {
    private final JsonLdPath path;
    private final String expectedType;

    public TypeIs(JsonLdPath path, String expectedType) {
        this.path = path;
        this.expectedType = expectedType;
    }

    public ValidationResult validate(JsonObject input) {
        List<String> types = Optional.of(input).map(it -> it.getJsonArray("@type")).stream().flatMap(Collection::stream).filter(it -> it.getValueType() == JsonValue.ValueType.STRING).map(JsonString.class::cast).map(JsonString::getString).toList();
        if (types.contains(this.expectedType)) {
            return ValidationResult.success();
        }
        JsonLdPath newPath = this.path.append("@type");
        Violation violation = Violation.violation((String)"%s was expected to be %s but it was not".formatted(newPath, this.expectedType), (String)newPath.toString(), types);
        return ValidationResult.failure((Violation)violation);
    }
}

