/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject.validators;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;

public class OptionalIdArray
implements Validator<JsonObject> {
    private final JsonLdPath path;
    private final Integer min;

    public OptionalIdArray(JsonLdPath path) {
        this(path, null);
    }

    public OptionalIdArray(JsonLdPath path, Integer min) {
        this.path = path;
        this.min = min;
    }

    public static Function<JsonLdPath, Validator<JsonObject>> min(Integer min) {
        return path -> new OptionalIdArray((JsonLdPath)path, min);
    }

    public ValidationResult validate(JsonObject input) {
        ValidationResult sizeResult = Optional.ofNullable(input.getJsonArray(this.path.last())).map(this::validateMin).orElse(ValidationResult.success());
        if (sizeResult.failed()) {
            return sizeResult;
        }
        return Optional.ofNullable(input.getJsonArray(this.path.last())).map(this::validateType).orElse(ValidationResult.success());
    }

    private ValidationResult validateMin(JsonArray array) {
        if (this.min == null || array.size() >= this.min) {
            return ValidationResult.success();
        }
        return ValidationResult.failure((Violation)Violation.violation((String)String.format("array '%s' should at least contains '%s' elements", this.path, this.min), (String)this.path.toString()));
    }

    private ValidationResult validateType(JsonArray array) {
        for (JsonValue value : array) {
            try {
                JsonString id = value.asJsonObject().getJsonString("@id");
                if (id != null && !id.getString().isBlank()) continue;
                return ValidationResult.failure((Violation)Violation.violation((String)String.format("contents of array '%s' should not be blank or empty", this.path), (String)this.path.toString()));
            }
            catch (ClassCastException e) {
                return ValidationResult.failure((Violation)Violation.violation((String)String.format("contents of array '%s' should be of type string", this.path), (String)this.path.toString()));
            }
        }
        return ValidationResult.success();
    }
}

