/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject.validators;

import jakarta.json.JsonObject;
import java.util.Optional;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;

public class LogDeprecatedValue
implements Validator<JsonObject> {
    public final String deprecatedLog;
    private final JsonLdPath path;
    private final Monitor monitor;

    public LogDeprecatedValue(JsonLdPath path, String deprecatedType, String attributeToUse, Monitor monitor) {
        this.path = path;
        this.monitor = monitor;
        this.deprecatedLog = String.format("The attribute %s has been deprecated in type %s, please use %s", path.last(), deprecatedType, attributeToUse);
    }

    public ValidationResult validate(JsonObject input) {
        return Optional.ofNullable(input.getJsonArray(this.path.last())).filter(it -> !it.isEmpty()).map(it -> {
            this.monitor.warning(this.deprecatedLog, new Throwable[0]);
            return ValidationResult.success();
        }).orElseGet(ValidationResult::success);
    }
}

