/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.stream.Stream;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.jsonobject.JsonWalker;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum JsonWalkers implements JsonWalker
{
    ROOT_OBJECT{

        @Override
        public Stream<JsonObject> extract(JsonObject object, JsonLdPath path) {
            return Stream.of(object);
        }
    }
    ,
    NESTED_OBJECT{

        @Override
        public Stream<JsonObject> extract(JsonObject object, JsonLdPath path) {
            JsonArray array = object.getJsonArray(path.last());
            if (array == null || array.isEmpty()) {
                return Stream.empty();
            }
            return Stream.of(array.getJsonObject(0));
        }
    }
    ,
    ARRAY_ITEMS{

        @Override
        public Stream<JsonObject> extract(JsonObject object, JsonLdPath path) {
            JsonArray array = object.getJsonArray(path.last());
            if (array == null) {
                return Stream.empty();
            }
            return array.stream().map(JsonValue::asJsonObject);
        }
    };

}

