/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.jsonobject;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.jsonobject.JsonWalker;
import org.eclipse.edc.validator.jsonobject.JsonWalkers;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;

public class JsonObjectValidator
implements Validator<JsonObject> {
    private final List<Validator<JsonObject>> validators = new ArrayList<Validator<JsonObject>>();
    private final JsonLdPath path;
    private final JsonWalker walker;

    protected JsonObjectValidator(JsonLdPath path, JsonWalker walker) {
        this.path = path;
        this.walker = walker;
    }

    public static Builder newValidator() {
        return Builder.newInstance(JsonLdPath.path(new String[0]), JsonWalkers.ROOT_OBJECT);
    }

    public ValidationResult validate(JsonObject input) {
        if (input == null) {
            return ValidationResult.failure((Violation)Violation.violation((String)"input json is null", (String)this.path.toString()));
        }
        return this.walker.extract(input, this.path).flatMap(target -> this.validators.stream().map(validator -> validator.validate(target))).reduce(ValidationResult::merge).orElse(ValidationResult.success());
    }

    public static class Builder {
        private final JsonObjectValidator validator;

        private Builder(JsonObjectValidator validator) {
            this.validator = validator;
        }

        public static Builder newInstance(JsonLdPath path, JsonWalker walker) {
            return new Builder(new JsonObjectValidator(path, walker));
        }

        public Builder verify(Function<JsonLdPath, Validator<JsonObject>> provider) {
            this.validator.validators.add(provider.apply(this.validator.path));
            return this;
        }

        public Builder verify(String fieldName, Function<JsonLdPath, Validator<JsonObject>> provider) {
            JsonLdPath newPath = this.validator.path.append(fieldName);
            this.validator.validators.add(provider.apply(newPath));
            return this;
        }

        public Builder verifyId(Function<JsonLdPath, Validator<JsonString>> provider) {
            JsonLdPath newPath = this.validator.path.append("@id");
            this.validator.validators.add((Validator<JsonObject>)((Validator)input -> ((Validator)provider.apply(newPath)).validate((Object)input.getJsonString("@id"))));
            return this;
        }

        public Builder verifyObject(String fieldName, UnaryOperator<Builder> provider) {
            JsonLdPath newPath = this.validator.path.append(fieldName);
            Builder builder = Builder.newInstance(newPath, JsonWalkers.NESTED_OBJECT);
            this.validator.validators.add(((Builder)provider.apply(builder)).build());
            return this;
        }

        public Builder verifyArrayItem(String fieldName, UnaryOperator<Builder> provider) {
            JsonLdPath newPath = this.validator.path.append(fieldName);
            Builder builder = Builder.newInstance(newPath, JsonWalkers.ARRAY_ITEMS);
            this.validator.validators.add(((Builder)provider.apply(builder)).build());
            return this;
        }

        public JsonObjectValidator build() {
            return this.validator;
        }
    }
}

