/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.spi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.transform.spi.AbstractProblemBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;

public class UnexpectedTypeBuilder
extends AbstractProblemBuilder<UnexpectedTypeBuilder> {
    private final TransformerContext context;
    private String actual = "unknown";
    private List<String> expected = new ArrayList<String>();

    public UnexpectedTypeBuilder(TransformerContext context) {
        this.context = context;
    }

    public UnexpectedTypeBuilder actual(String actual) {
        this.actual = actual;
        return this;
    }

    public UnexpectedTypeBuilder actual(Class<?> actual) {
        this.actual = actual == null ? null : actual.getName();
        return this;
    }

    public UnexpectedTypeBuilder actual(Enum<?> actual) {
        this.actual = actual == null ? null : actual.toString();
        return this;
    }

    public UnexpectedTypeBuilder expected(String expectedType) {
        if (expectedType == null) {
            return this;
        }
        this.expected.add(expectedType);
        return this;
    }

    public UnexpectedTypeBuilder expected(Enum<?> expectedType) {
        if (expectedType == null) {
            return this;
        }
        this.expected.add(expectedType.toString());
        return this;
    }

    public UnexpectedTypeBuilder expected(Class<?> expectedType) {
        if (expectedType == null) {
            return this;
        }
        if (expectedType.isEnum()) {
            for (Object constant : expectedType.getEnumConstants()) {
                this.expected.add(constant.toString());
            }
        } else {
            this.expected.add(expectedType.getName());
        }
        return this;
    }

    @Override
    public void report() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            builder.append(this.type);
            if (this.property != null) {
                builder.append(" property '").append(this.property).append("'");
            }
        } else if (this.property != null) {
            builder.append("Property '").append(this.property).append("'");
        }
        if (this.expected.isEmpty()) {
            if (builder.length() == 0) {
                builder.append("Value ");
            }
            builder.append("was not of the expected type");
        } else {
            if (builder.length() == 0) {
                builder.append("Value");
            }
            builder.append(" must be ").append(this.concatList(this.expected));
        }
        if (this.actual != null) {
            builder.append(" but was: ").append(this.actual);
        }
        this.context.reportProblem(builder.toString());
    }
}

