/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.spi;

import java.util.List;
import java.util.Objects;

public abstract class AbstractProblemBuilder<B extends AbstractProblemBuilder<?>> {
    protected static final String UNKNOWN = "unknown";
    protected String type;
    protected String property;

    public B type(String type) {
        this.type = type;
        return (B)this;
    }

    public B type(Class<?> type) {
        this.type = type != null ? type.getName() : null;
        return (B)this;
    }

    public B type(Enum<?> type) {
        this.type = type != null ? type.toString() : null;
        return (B)this;
    }

    public B property(String property) {
        this.property = property;
        return (B)this;
    }

    protected String concatList(List<String> elements) {
        Objects.requireNonNull(elements);
        if (elements.size() == 0) {
            return "";
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        if (elements.size() == 2) {
            return elements.get(0) + " or " + elements.get(1);
        }
        return String.join((CharSequence)", ", elements.subList(0, elements.size() - 1)) + ", or " + elements.get(elements.size() - 1);
    }

    public abstract void report();
}

