/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.dspace.from;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonCollectors;
import java.util.Set;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromDataAddressDspaceTransformer
extends AbstractJsonLdTransformer<DataAddress, JsonObject> {
    private static final Set<String> EXCLUDED_PROPERTIES = Set.of("https://w3id.org/edc/v0.0.1/ns/type");
    private final JsonBuilderFactory jsonFactory;
    private final ObjectMapper mapper;

    public JsonObjectFromDataAddressDspaceTransformer(JsonBuilderFactory jsonFactory, ObjectMapper mapper) {
        super(DataAddress.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
        this.mapper = mapper;
    }

    @Nullable
    public JsonObject transform(@NotNull DataAddress dataAddress, @NotNull TransformerContext context) {
        JsonArray endpointProperties = (JsonArray)dataAddress.getProperties().entrySet().stream().filter(e -> !EXCLUDED_PROPERTIES.contains(e.getKey())).map(it -> this.endpointProperty((String)it.getKey(), it.getValue())).collect(JsonCollectors.toJsonArray());
        return this.jsonFactory.createObjectBuilder().add("@type", "https://w3id.org/dspace/v0.8/DataAddress").add("https://w3id.org/dspace/v0.8/endpointType", dataAddress.getType()).add("https://w3id.org/dspace/v0.8/endpointProperties", (JsonValue)endpointProperties).build();
    }

    private JsonObject endpointProperty(String key, Object value) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@type", "https://w3id.org/dspace/v0.8/EndpointProperty").add("https://w3id.org/dspace/v0.8/name", key);
        if (value instanceof String) {
            String stringVal = (String)value;
            builder.add("https://w3id.org/dspace/v0.8/value", stringVal);
        } else {
            builder.add("https://w3id.org/dspace/v0.8/value", (JsonValue)this.mapper.convertValue(value, JsonObject.class));
        }
        return builder.build();
    }
}

