/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.to;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.UnexpectedTypeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDataAddressTransformer
extends AbstractJsonLdTransformer<JsonObject, DataAddress> {
    public static final String PROPERTIES_KEY = "https://w3id.org/edc/v0.0.1/ns/properties";

    public JsonObjectToDataAddressTransformer() {
        super(JsonObject.class, DataAddress.class);
    }

    @Nullable
    public DataAddress transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        DataAddress.Builder builder = DataAddress.Builder.newInstance();
        this.visitProperties(jsonObject, (s, v) -> this.transformProperties((String)s, (JsonValue)v, builder, context));
        return builder.build();
    }

    private void transformProperties(String key, JsonValue jsonValue, DataAddress.Builder builder, TransformerContext context) {
        if (PROPERTIES_KEY.equals(key) && jsonValue instanceof JsonArray) {
            JsonObject props = jsonValue.asJsonArray().getJsonObject(0);
            this.visitProperties(props, (k, val) -> this.transformProperties((String)k, (JsonValue)val, builder, context));
        } else {
            Object object = this.transformGenericProperty(jsonValue, context);
            if (object instanceof String) {
                builder.property(key, (Object)object.toString());
            } else {
                ((UnexpectedTypeBuilder)((UnexpectedTypeBuilder)context.problem().unexpectedType().type("property")).property(key)).actual(object == null ? "null" : object.toString()).expected((Enum)JsonValue.ValueType.STRING).report();
            }
        }
    }
}

