/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.from;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromQuerySpecTransformer
extends AbstractJsonLdTransformer<QuerySpec, JsonObject> {
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromQuerySpecTransformer(JsonBuilderFactory jsonFactory) {
        super(QuerySpec.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull QuerySpec querySpec, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("@type", "https://w3id.org/edc/v0.0.1/ns/QuerySpec");
        builder.add("https://w3id.org/edc/v0.0.1/ns/limit", querySpec.getLimit());
        builder.add("https://w3id.org/edc/v0.0.1/ns/offset", querySpec.getOffset());
        builder.add("https://w3id.org/edc/v0.0.1/ns/sortOrder", querySpec.getSortOrder().toString());
        if (querySpec.getSortField() != null) {
            builder.add("https://w3id.org/edc/v0.0.1/ns/sortField", querySpec.getSortField());
        }
        JsonArray filterExpressions = querySpec.getFilterExpression().stream().map(expression -> (JsonObject)context.transform(expression, JsonObject.class)).collect(() -> ((JsonBuilderFactory)this.jsonFactory).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::add).build();
        builder.add("https://w3id.org/edc/v0.0.1/ns/filterExpression", (JsonValue)filterExpressions);
        return builder.build();
    }
}

