/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.dspace.to;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDataAddressDspaceTransformer
extends AbstractJsonLdTransformer<JsonObject, DataAddress> {
    public JsonObjectToDataAddressDspaceTransformer() {
        super(JsonObject.class, DataAddress.class);
    }

    @Nullable
    public DataAddress transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        DataAddress.Builder builder = DataAddress.Builder.newInstance();
        this.visitProperties(jsonObject, (s, v) -> this.transformProperties((String)s, (JsonValue)v, builder, context));
        return builder.build();
    }

    private void transformProperties(String key, JsonValue jsonValue, DataAddress.Builder builder, TransformerContext context) {
        switch (key) {
            case "https://w3id.org/dspace/v0.8/endpoint": {
                break;
            }
            case "https://w3id.org/dspace/v0.8/endpointType": {
                builder.type(this.transformString(jsonValue, context));
                break;
            }
            case "https://w3id.org/dspace/v0.8/endpointProperties": {
                this.transformEndpointProperties(jsonValue, ep -> builder.property(ep.name(), (Object)ep.value()), context);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + key);
            }
        }
    }

    private void transformEndpointProperties(JsonValue jsonValue, Consumer<DspaceEndpointProperty> consumer, TransformerContext context) {
        Function<JsonObject, DspaceEndpointProperty> converter = jo -> {
            String name = this.transformString((JsonValue)jo.get((Object)"https://w3id.org/dspace/v0.8/name"), context);
            String value = this.transformString((JsonValue)jo.get((Object)"https://w3id.org/dspace/v0.8/value"), context);
            return new DspaceEndpointProperty(name, value);
        };
        if (jsonValue instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonValue;
            consumer.accept(converter.apply(object));
        }
        if (jsonValue instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonValue;
            array.forEach(jv -> this.transformEndpointProperties((JsonValue)jv, consumer, context));
        }
    }

    private record DspaceEndpointProperty(String name, String value) {
    }
}

