/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transform.TransformerContextImpl;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.jetbrains.annotations.NotNull;

public class TypeTransformerRegistryImpl
implements TypeTransformerRegistry {
    private final Map<String, Class<?>> aliases = new HashMap();
    private final List<TypeTransformer<?, ?>> transformers = new ArrayList();
    private final Map<String, TypeTransformerRegistry> contextRegistries = new HashMap<String, TypeTransformerRegistry>();

    public void register(TypeTransformer<?, ?> transformer) {
        this.transformers.add(transformer);
    }

    @NotNull
    public TypeTransformerRegistry forContext(String context) {
        return this.contextRegistries.computeIfAbsent(context, k -> new ContextTransformerRegistry(this));
    }

    @NotNull
    public <INPUT, OUTPUT> TypeTransformer<INPUT, OUTPUT> transformerFor(@NotNull INPUT input, @NotNull Class<OUTPUT> outputType) {
        return this.transformers.stream().filter(t -> t.getInputType().isInstance(input) && t.getOutputType().equals(outputType)).findAny().map(it -> it).orElseThrow(() -> new EdcException(String.format("No Transformer registered that can handle %s -> %s", input.getClass(), outputType)));
    }

    public <INPUT, OUTPUT> Result<OUTPUT> transform(@NotNull INPUT input, @NotNull Class<OUTPUT> outputType) {
        Objects.requireNonNull(input);
        TransformerContextImpl context = new TransformerContextImpl(this);
        OUTPUT result = context.transform(input, outputType);
        if (context.hasProblems()) {
            return Result.failure(context.getProblems());
        }
        return Result.success(result);
    }

    private static class ContextTransformerRegistry
    extends TypeTransformerRegistryImpl {
        private final TypeTransformerRegistry parent;

        ContextTransformerRegistry(TypeTransformerRegistry parent) {
            this.parent = parent;
        }

        @Override
        @NotNull
        public TypeTransformerRegistry forContext(String context) {
            throw new EdcException("'forContext' cannot be called on ContextTransformerRegistry, please refer to the generic TypeTransformerRegistry");
        }

        @Override
        @NotNull
        public <INPUT, OUTPUT> TypeTransformer<INPUT, OUTPUT> transformerFor(@NotNull INPUT input, @NotNull Class<OUTPUT> outputType) {
            try {
                return super.transformerFor(input, outputType);
            }
            catch (EdcException e) {
                return this.parent.transformerFor(input, outputType);
            }
        }
    }
}

