/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.to;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.stream.Collectors;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;

public class JsonValueToGenericTypeTransformer
extends AbstractJsonLdTransformer<JsonValue, Object> {
    private final TypeManager typeManager;
    private final String typeContext;

    public JsonValueToGenericTypeTransformer(TypeManager typeManager, String typeContext) {
        super(JsonValue.class, Object.class);
        this.typeManager = typeManager;
        this.typeContext = typeContext;
    }

    public Object transform(@NotNull JsonValue value, @NotNull TransformerContext context) {
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            if (object.containsKey((Object)"@value")) {
                JsonValue valueField = (JsonValue)object.get((Object)"@value");
                if (valueField == null) {
                    return this.toJavaType(object, context);
                }
                return this.transform(valueField, context);
            }
            return this.toJavaType(object, context);
        }
        if (value instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)value;
            return jsonArray.stream().map(entry -> this.transform((JsonValue)entry, context)).collect(Collectors.toList());
        }
        if (value instanceof JsonString) {
            JsonString jsonString = (JsonString)value;
            return jsonString.getString();
        }
        if (value instanceof JsonNumber) {
            JsonNumber jsonNumber = (JsonNumber)value;
            return jsonNumber.doubleValue();
        }
        if (value.getValueType() == JsonValue.ValueType.FALSE) {
            return Boolean.FALSE;
        }
        if (value.getValueType() == JsonValue.ValueType.TRUE) {
            return Boolean.TRUE;
        }
        return null;
    }

    private Object toJavaType(JsonObject object, TransformerContext context) {
        try {
            return this.typeManager.getMapper(this.typeContext).readValue(object.toString(), Object.class);
        }
        catch (JsonProcessingException e) {
            context.reportProblem(String.format("Failed to read value: %s", e.getMessage()));
            return null;
        }
    }
}

