/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.query.SortOrder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToQuerySpecTransformer
extends AbstractJsonLdTransformer<JsonObject, QuerySpec> {
    public JsonObjectToQuerySpecTransformer() {
        super(JsonObject.class, QuerySpec.class);
    }

    @Nullable
    public QuerySpec transform(@NotNull JsonObject input, @NotNull TransformerContext context) {
        QuerySpec.Builder builder = QuerySpec.Builder.newInstance();
        this.visitProperties(input, key -> {
            switch (key) {
                case "https://w3id.org/edc/v0.0.1/ns/offset": {
                    return v -> builder.offset(Integer.valueOf(this.transformInt((JsonValue)v, context)));
                }
                case "https://w3id.org/edc/v0.0.1/ns/limit": {
                    return v -> builder.limit(Integer.valueOf(this.transformInt((JsonValue)v, context)));
                }
                case "https://w3id.org/edc/v0.0.1/ns/filterExpression": {
                    return v -> builder.filter(this.transformArray((JsonValue)v, Criterion.class, context));
                }
                case "https://w3id.org/edc/v0.0.1/ns/sortOrder": {
                    return v -> builder.sortOrder(SortOrder.valueOf((String)this.transformString((JsonValue)v, context)));
                }
                case "https://w3id.org/edc/v0.0.1/ns/sortField": {
                    return v -> builder.sortField(this.transformString((JsonValue)v, context));
                }
            }
            return JsonObjectToQuerySpecTransformer.doNothing();
        });
        return builder.build();
    }
}

