/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.to;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDataPlaneInstanceTransformer
extends AbstractJsonLdTransformer<JsonObject, DataPlaneInstance> {
    public JsonObjectToDataPlaneInstanceTransformer() {
        super(JsonObject.class, DataPlaneInstance.class);
    }

    @Nullable
    public DataPlaneInstance transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        DataPlaneInstance.Builder builder = ((DataPlaneInstance.Builder)((DataPlaneInstance.Builder)DataPlaneInstance.Builder.newInstance().id(this.nodeId((JsonValue)jsonObject))).url(this.transformUrl((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/url"), context)).lastActive(this.transformLong((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/lastActive"), context)).allowedSourceTypes(this.asSetOfStrings((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/allowedSourceTypes"), context)).allowedTransferType(this.asSetOfStrings((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/allowedTransferTypes"), context)).destinationProvisionTypes(this.asSetOfStrings((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/destinationProvisionTypes"), context)).stateTimestamp(this.transformLong((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/stateTimestamp"), context))).turnCount(this.transformInt((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/turnCount"), context)).allowedDestTypes(this.asSetOfStrings((JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/allowedDestTypes"), context));
        JsonValue properties = (JsonValue)jsonObject.get((Object)"https://w3id.org/edc/v0.0.1/ns/properties");
        if (properties != null) {
            this.visitProperties(properties.asJsonArray().getJsonObject(0), (k, val) -> builder.property(k, this.transformGenericProperty((JsonValue)val, context)));
        }
        return builder.build();
    }

    private URL transformUrl(JsonValue value, @NotNull TransformerContext context) {
        try {
            return new URL(Objects.requireNonNull(this.transformString(value, context)));
        }
        catch (MalformedURLException e) {
            context.reportProblem(e.getMessage());
            return null;
        }
    }

    @NotNull
    private Set<String> asSetOfStrings(JsonValue jsonValue, TransformerContext context) {
        if (jsonValue == null) {
            return Collections.emptySet();
        }
        return jsonValue.asJsonArray().stream().map(it -> this.transformString((JsonValue)it, context)).collect(Collectors.toSet());
    }

    private long transformLong(JsonValue jsonValue, @NotNull TransformerContext context) {
        if (jsonValue == null) {
            return 0L;
        }
        if (jsonValue instanceof JsonNumber) {
            JsonNumber number = (JsonNumber)jsonValue;
            return number.longValue();
        }
        if (jsonValue instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonValue;
            return this.transformLong((JsonValue)array.getJsonObject(0).get((Object)"@value"), context);
        }
        context.reportProblem("Cannot convert a " + String.valueOf(jsonValue.getValueType()) + " to a long!");
        return 0L;
    }
}

