/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDataAddressTransformer
extends AbstractJsonLdTransformer<JsonObject, DataAddress> {
    public static final String PROPERTIES_KEY = "https://w3id.org/edc/v0.0.1/ns/properties";

    public JsonObjectToDataAddressTransformer() {
        super(JsonObject.class, DataAddress.class);
    }

    @Nullable
    public DataAddress transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        DataAddress.Builder builder = DataAddress.Builder.newInstance();
        this.visitProperties(jsonObject, (s, v) -> this.transformProperties((String)s, (JsonValue)v, builder, context));
        return builder.build();
    }

    private void transformProperties(String key, JsonValue jsonValue, DataAddress.Builder builder, TransformerContext context) {
        JsonObject firstValue = this.returnJsonObject(jsonValue, context, key, true);
        if (firstValue != null && PROPERTIES_KEY.equals(key)) {
            this.visitProperties(firstValue, (k, val) -> this.transformProperties((String)k, (JsonValue)val, builder, context));
        } else if (firstValue != null && "https://w3id.org/edc/v0.0.1/ns/responseChannel".equals(key)) {
            builder.responseChannel((DataAddress)this.transformObject((JsonValue)firstValue, DataAddress.class, context));
        } else {
            builder.property(key, this.transformGenericProperty(jsonValue, context));
        }
    }
}

