/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstanceStates;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromDataPlaneInstanceTransformer
extends AbstractJsonLdTransformer<DataPlaneInstance, JsonObject> {
    private final JsonBuilderFactory jsonFactory;
    private final TypeManager typeManager;
    private final String typeContext;

    public JsonObjectFromDataPlaneInstanceTransformer(JsonBuilderFactory jsonFactory, TypeManager typeManager, String typeContext) {
        super(DataPlaneInstance.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
        this.typeManager = typeManager;
        this.typeContext = typeContext;
    }

    @Nullable
    public JsonObject transform(@NotNull DataPlaneInstance dataPlaneInstance, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", dataPlaneInstance.getId()).add("@type", "https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance").add("https://w3id.org/edc/v0.0.1/ns/url", dataPlaneInstance.getUrl().toString()).add("https://w3id.org/edc/v0.0.1/ns/lastActive", dataPlaneInstance.getLastActive()).add("https://w3id.org/edc/v0.0.1/ns/stateTimestamp", dataPlaneInstance.getStateTimestamp()).add("https://w3id.org/edc/v0.0.1/ns/allowedSourceTypes", this.jsonFactory.createArrayBuilder((Collection)dataPlaneInstance.getAllowedSourceTypes())).add("https://w3id.org/edc/v0.0.1/ns/allowedTransferTypes", this.jsonFactory.createArrayBuilder((Collection)dataPlaneInstance.getAllowedTransferTypes())).add("https://w3id.org/edc/v0.0.1/ns/destinationProvisionTypes", this.jsonFactory.createArrayBuilder((Collection)dataPlaneInstance.getDestinationProvisionTypes()));
        if (dataPlaneInstance.getProperties() != null && !dataPlaneInstance.getProperties().isEmpty()) {
            JsonObjectBuilder propBuilder = this.jsonFactory.createObjectBuilder();
            this.transformProperties(dataPlaneInstance.getProperties(), propBuilder, this.typeManager.getMapper(this.typeContext), context);
            builder.add("https://w3id.org/edc/v0.0.1/ns/properties", propBuilder);
        }
        String state = Optional.ofNullable(DataPlaneInstanceStates.from((int)dataPlaneInstance.getState())).map(Enum::name).orElse(null);
        this.addIfNotNull(state, "https://w3id.org/edc/v0.0.1/ns/state", builder);
        return builder.build();
    }
}

