/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.from;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.function.Function;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromDataAddressTransformer
extends AbstractJsonLdTransformer<DataAddress, JsonObject> {
    private final JsonBuilderFactory jsonBuilderFactory;
    private final ObjectMapper mapper;

    public JsonObjectFromDataAddressTransformer(JsonBuilderFactory jsonBuilderFactory, TypeManager typeManager, String typeContext) {
        super(DataAddress.class, JsonObject.class);
        this.jsonBuilderFactory = jsonBuilderFactory;
        this.mapper = typeManager.getMapper(typeContext);
    }

    @Nullable
    public JsonObject transform(@NotNull DataAddress dataAddress, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonBuilderFactory.createObjectBuilder();
        builder.add("@type", "https://w3id.org/edc/v0.0.1/ns/DataAddress");
        Function<Object, JsonValue> func = v -> {
            if (v instanceof DataAddress) {
                return (JsonValue)context.transform(v, JsonObject.class);
            }
            return (JsonValue)this.mapper.convertValue(v, JsonValue.class);
        };
        this.transformProperties(dataAddress.getProperties(), builder, func, context);
        return builder.build();
    }
}

