/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.InvalidPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromCriterionTransformer
extends AbstractJsonLdTransformer<Criterion, JsonObject> {
    private final JsonBuilderFactory jsonFactory;
    private final TypeManager typeManager;
    private final String typeContext;

    public JsonObjectFromCriterionTransformer(JsonBuilderFactory jsonFactory, TypeManager typeManager, String typeContext) {
        super(Criterion.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
        this.typeManager = typeManager;
        this.typeContext = typeContext;
    }

    @Nullable
    public JsonObject transform(@NotNull Criterion querySpec, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder();
        builder.add("@type", "https://w3id.org/edc/v0.0.1/ns/Criterion");
        this.addValue(builder, "https://w3id.org/edc/v0.0.1/ns/operandLeft", querySpec.getOperandLeft(), context);
        builder.add("https://w3id.org/edc/v0.0.1/ns/operator", querySpec.getOperator());
        if (querySpec.getOperandRight() != null) {
            this.addValue(builder, "https://w3id.org/edc/v0.0.1/ns/operandRight", querySpec.getOperandRight(), context);
        }
        return builder.build();
    }

    private void addValue(JsonObjectBuilder builder, String field, Object value, TransformerContext context) {
        try {
            builder.add(field, (JsonValue)this.typeManager.getMapper(this.typeContext).convertValue(value, JsonValue.class));
        }
        catch (IllegalArgumentException e) {
            ((InvalidPropertyBuilder)((InvalidPropertyBuilder)context.problem().invalidProperty().type("@value")).property(field)).value(value != null ? value.toString() : "null").error(e.getMessage()).report();
        }
    }
}

