/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.dspace.v2024.from;

import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonCollectors;
import java.util.Set;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromDataAddressDspace2024Transformer
extends AbstractNamespaceAwareJsonLdTransformer<DataAddress, JsonObject> {
    private static final Set<String> EXCLUDED_PROPERTIES = Set.of("https://w3id.org/edc/v0.0.1/ns/type");
    private final JsonBuilderFactory jsonFactory;
    private final TypeManager typeManager;
    private final String typeContext;

    public JsonObjectFromDataAddressDspace2024Transformer(JsonBuilderFactory jsonFactory, TypeManager typeManager, String typeContext, JsonLdNamespace namespace) {
        super(DataAddress.class, JsonObject.class, namespace);
        this.jsonFactory = jsonFactory;
        this.typeManager = typeManager;
        this.typeContext = typeContext;
    }

    @Nullable
    public JsonObject transform(@NotNull DataAddress dataAddress, @NotNull TransformerContext context) {
        JsonArray endpointProperties = (JsonArray)dataAddress.getProperties().entrySet().stream().filter(e -> !EXCLUDED_PROPERTIES.contains(e.getKey())).map(it -> this.endpointProperty((String)it.getKey(), it.getValue())).collect(JsonCollectors.toJsonArray());
        return this.jsonFactory.createObjectBuilder().add("@type", this.forNamespace("DataAddress")).add(this.forNamespace("endpointType"), (JsonValue)this.createId(this.jsonFactory, dataAddress.getType())).add(this.forNamespace("endpointProperties"), (JsonValue)endpointProperties).build();
    }

    private JsonObject endpointProperty(String key, Object value) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@type", this.forNamespace("EndpointProperty")).add(this.forNamespace("name"), key);
        if (value instanceof String) {
            String stringVal = (String)value;
            builder.add(this.forNamespace("value"), stringVal);
        } else {
            builder.add(this.forNamespace("value"), (JsonValue)this.typeManager.getMapper(this.typeContext).convertValue(value, JsonObject.class));
        }
        return builder.build();
    }
}

