/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.edc.from;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstanceStates;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromDataPlaneInstanceV3Transformer
extends AbstractJsonLdTransformer<DataPlaneInstance, JsonObject> {
    private final JsonBuilderFactory jsonFactory;
    private final TypeManager typeManager;
    private final String typeContext;

    public JsonObjectFromDataPlaneInstanceV3Transformer(JsonBuilderFactory jsonFactory, TypeManager typeManager, String typeContext) {
        super(DataPlaneInstance.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
        this.typeManager = typeManager;
        this.typeContext = typeContext;
    }

    @Nullable
    public JsonObject transform(@NotNull DataPlaneInstance dataPlaneInstance, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", dataPlaneInstance.getId()).add("@type", "https://w3id.org/edc/v0.0.1/ns/DataPlaneInstance").add("https://w3id.org/edc/v0.0.1/ns/url", dataPlaneInstance.getUrl().toString()).add("https://w3id.org/edc/v0.0.1/ns/lastActive", dataPlaneInstance.getLastActive()).add("https://w3id.org/edc/v0.0.1/ns/turnCount", dataPlaneInstance.getTurnCount());
        if (dataPlaneInstance.getProperties() != null && !dataPlaneInstance.getProperties().isEmpty()) {
            JsonObjectBuilder propBuilder = this.jsonFactory.createObjectBuilder();
            this.transformProperties(dataPlaneInstance.getProperties(), propBuilder, this.typeManager.getMapper(this.typeContext), context);
            builder.add("https://w3id.org/edc/v0.0.1/ns/properties", propBuilder);
        }
        JsonArrayBuilder srcBldr = this.jsonFactory.createArrayBuilder((Collection)dataPlaneInstance.getAllowedSourceTypes());
        builder.add("https://w3id.org/edc/v0.0.1/ns/allowedSourceTypes", srcBldr);
        JsonArrayBuilder dstBldr = this.jsonFactory.createArrayBuilder((Collection)dataPlaneInstance.getAllowedDestTypes());
        builder.add("https://w3id.org/edc/v0.0.1/ns/allowedDestTypes", dstBldr);
        JsonArrayBuilder transferTypesBldr = this.jsonFactory.createArrayBuilder((Collection)dataPlaneInstance.getAllowedTransferTypes());
        builder.add("https://w3id.org/edc/v0.0.1/ns/allowedTransferTypes", transferTypesBldr);
        String state = Optional.ofNullable(DataPlaneInstanceStates.from((int)dataPlaneInstance.getState())).map(Enum::name).orElse(null);
        this.addIfNotNull(state, "https://w3id.org/edc/v0.0.1/ns/state", builder);
        builder.add("https://w3id.org/edc/v0.0.1/ns/stateTimestamp", dataPlaneInstance.getStateTimestamp());
        return builder.build();
    }
}

