/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform.transformer.dspace.to;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.edc.jsonld.spi.JsonLdNamespace;
import org.eclipse.edc.jsonld.spi.transformer.AbstractNamespaceAwareJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToDataAddressDspaceTransformer
extends AbstractNamespaceAwareJsonLdTransformer<JsonObject, DataAddress> {
    public JsonObjectToDataAddressDspaceTransformer() {
        this(new JsonLdNamespace("https://w3id.org/dspace/v0.8/"));
    }

    public JsonObjectToDataAddressDspaceTransformer(JsonLdNamespace namespace) {
        super(JsonObject.class, DataAddress.class, namespace);
    }

    @Nullable
    public DataAddress transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        DataAddress.Builder builder = DataAddress.Builder.newInstance();
        this.transformString((JsonValue)jsonObject.get((Object)this.forNamespace("endpointType")), arg_0 -> ((DataAddress.Builder)builder).type(arg_0), context);
        this.transformEndpointProperties((JsonValue)jsonObject.get((Object)this.forNamespace("endpointProperties")), ep -> builder.property(ep.name(), (Object)ep.value()), context);
        return builder.build();
    }

    private void transformEndpointProperties(JsonValue jsonValue, Consumer<DspaceEndpointProperty> consumer, TransformerContext context) {
        Function<JsonObject, DspaceEndpointProperty> converter = jo -> {
            String name = this.transformString((JsonValue)jo.get((Object)this.forNamespace("name")), context);
            String value = this.transformString((JsonValue)jo.get((Object)this.forNamespace("value")), context);
            return new DspaceEndpointProperty(name, value);
        };
        if (jsonValue instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonValue;
            consumer.accept(converter.apply(object));
        }
        if (jsonValue instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonValue;
            array.forEach(jv -> this.transformEndpointProperties((JsonValue)jv, consumer, context));
        }
    }

    private record DspaceEndpointProperty(String name, String value) {
    }
}

