/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.edc.transform.spi.ProblemBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.jetbrains.annotations.Nullable;

public class TransformerContextImpl
implements TransformerContext {
    private final List<String> problems = new ArrayList<String>();
    private final TypeTransformerRegistry registry;
    private final Map<Class<?>, Map<String, AtomicReference<?>>> data = new HashMap();

    public TransformerContextImpl(TypeTransformerRegistry registry) {
        this.registry = registry;
    }

    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    public List<String> getProblems() {
        return this.problems;
    }

    public void reportProblem(String problem) {
        this.problems.add(problem);
    }

    public ProblemBuilder problem() {
        return new ProblemBuilder((TransformerContext)this);
    }

    @Nullable
    public <INPUT, OUTPUT> OUTPUT transform(INPUT object, Class<OUTPUT> outputType) {
        if (object == null) {
            return null;
        }
        return (OUTPUT)this.registry.transformerFor(object, outputType).transform(object, (TransformerContext)this);
    }

    public void setData(Class<?> type, String key, Object value) {
        this.data.computeIfAbsent(type, t -> new HashMap()).put(key, new AtomicReference<Object>(value));
    }

    public Object consumeData(Class<?> type, String key) {
        return Optional.of(type).map(this.data::get).map(typeMap -> (AtomicReference)typeMap.get(key)).map(reference -> reference.getAndSet(null)).orElse(null);
    }
}

