/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.transferprocess.validation;

import jakarta.json.JsonObject;
import org.eclipse.edc.api.validation.DataAddressValidator;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.validator.jsonobject.JsonLdPath;
import org.eclipse.edc.validator.jsonobject.JsonObjectValidator;
import org.eclipse.edc.validator.jsonobject.validators.LogDeprecatedValue;
import org.eclipse.edc.validator.jsonobject.validators.MandatoryValue;
import org.eclipse.edc.validator.jsonobject.validators.OptionalIdNotBlank;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;

public class TransferRequestValidator {
    public static Validator<JsonObject> instance(Monitor monitor) {
        return JsonObjectValidator.newValidator().verifyId(OptionalIdNotBlank::new).verify(MandatoryCounterPartyAddressOrConnectorAddress::new).verify("https://w3id.org/edc/v0.0.1/ns/connectorAddress", path -> new LogDeprecatedValue(path, "https://w3id.org/edc/v0.0.1/ns/TransferRequest", "https://w3id.org/edc/v0.0.1/ns/counterPartyAddress", monitor)).verify("https://w3id.org/edc/v0.0.1/ns/contractId", MandatoryValue::new).verify("https://w3id.org/edc/v0.0.1/ns/protocol", MandatoryValue::new).verify("https://w3id.org/edc/v0.0.1/ns/assetId", MandatoryValue::new).verify("https://w3id.org/edc/v0.0.1/ns/transferType", MandatoryValue::new).verifyObject("https://w3id.org/edc/v0.0.1/ns/dataDestination", DataAddressValidator::instance).build();
    }

    private record MandatoryCounterPartyAddressOrConnectorAddress(JsonLdPath path) implements Validator<JsonObject>
    {
        public ValidationResult validate(JsonObject input) {
            MandatoryValue counterPartyAddress = new MandatoryValue(this.path.append("https://w3id.org/edc/v0.0.1/ns/counterPartyAddress"));
            ValidationResult validateCounterParty = counterPartyAddress.validate(input);
            if (validateCounterParty.succeeded()) {
                return ValidationResult.success();
            }
            MandatoryValue connectorAddress = new MandatoryValue(this.path.append("https://w3id.org/edc/v0.0.1/ns/connectorAddress"));
            ValidationResult validateConnectorAddress = connectorAddress.validate(input);
            if (validateConnectorAddress.succeeded()) {
                return ValidationResult.success();
            }
            return validateCounterParty;
        }
    }
}

