/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.transferprocess.transform;

import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcessStates;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromTransferProcessTransformer
extends AbstractJsonLdTransformer<TransferProcess, JsonObject> {
    private final JsonBuilderFactory builderFactory;

    public JsonObjectFromTransferProcessTransformer(JsonBuilderFactory builderFactory) {
        super(TransferProcess.class, JsonObject.class);
        this.builderFactory = builderFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull TransferProcess input, @NotNull TransformerContext context) {
        JsonArray callbackAddresses = input.getCallbackAddresses().stream().map(it -> (JsonObject)context.transform(it, JsonObject.class)).collect(Collectors.collectingAndThen(Collectors.toList(), l -> this.builderFactory.createArrayBuilder((Collection)l).build()));
        JsonObject dataDestination = (JsonObject)context.transform((Object)input.getDataDestination(), JsonObject.class);
        JsonObjectBuilder builder = this.builderFactory.createObjectBuilder().add("@id", input.getId()).add("@type", "https://w3id.org/edc/v0.0.1/ns/TransferProcess").add("https://w3id.org/edc/v0.0.1/ns/correlationId", input.getCorrelationId()).add("https://w3id.org/edc/v0.0.1/ns/state", TransferProcessStates.from((int)input.getState()).name()).add("https://w3id.org/edc/v0.0.1/ns/stateTimestamp", input.getStateTimestamp()).add("https://w3id.org/edc/v0.0.1/ns/type", input.getType().name()).add("https://w3id.org/edc/v0.0.1/ns/assetId", input.getAssetId()).add("https://w3id.org/edc/v0.0.1/ns/contractId", input.getContractId()).add("https://w3id.org/edc/v0.0.1/ns/callbackAddresses", (JsonValue)callbackAddresses).add("https://w3id.org/edc/v0.0.1/ns/dataDestination", (JsonValue)dataDestination);
        Optional.ofNullable(input.getTransferType()).ifPresent(it -> builder.add("https://w3id.org/edc/v0.0.1/ns/transferType", it));
        Optional.ofNullable(input.getErrorDetail()).ifPresent(it -> builder.add("https://w3id.org/edc/v0.0.1/ns/errorDetail", it));
        return builder.build();
    }
}

