/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.transferprocess.transform;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.edc.connector.transfer.spi.types.TransferRequest;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToTransferRequestTransformer
extends AbstractJsonLdTransformer<JsonObject, TransferRequest> {
    public JsonObjectToTransferRequestTransformer() {
        super(JsonObject.class, TransferRequest.class);
    }

    @Nullable
    public TransferRequest transform(@NotNull JsonObject input, @NotNull TransformerContext context) {
        TransferRequest.Builder builder = TransferRequest.Builder.newInstance();
        builder.id(this.nodeId((JsonValue)input));
        this.visitProperties(input, k -> switch (k) {
            case "https://w3id.org/edc/v0.0.1/ns/connectorAddress" -> v -> builder.connectorAddress(this.transformString((JsonValue)v, context));
            case "https://w3id.org/edc/v0.0.1/ns/contractId" -> v -> builder.contractId(this.transformString((JsonValue)v, context));
            case "https://w3id.org/edc/v0.0.1/ns/dataDestination" -> v -> builder.dataDestination((DataAddress)this.transformObject((JsonValue)v, DataAddress.class, context));
            case "https://w3id.org/edc/v0.0.1/ns/properties" -> v -> this.transformStringProperties((JsonValue)v, arg_0 -> ((TransferRequest.Builder)builder).properties(arg_0), context);
            case "https://w3id.org/edc/v0.0.1/ns/callbackAddresses" -> v -> {
                ArrayList addresses = new ArrayList();
                this.transformArrayOrObject((JsonValue)v, CallbackAddress.class, addresses::add, context);
                builder.callbackAddresses(addresses);
            };
            case "https://w3id.org/edc/v0.0.1/ns/privateProperties" -> v -> this.transformProperties((JsonValue)v, arg_0 -> ((TransferRequest.Builder)builder).privateProperties(arg_0), context);
            case "https://w3id.org/edc/v0.0.1/ns/protocol" -> v -> builder.protocol(this.transformString((JsonValue)v, context));
            case "https://w3id.org/edc/v0.0.1/ns/connectorId" -> v -> builder.connectorId(this.transformString((JsonValue)v, context));
            case "https://w3id.org/edc/v0.0.1/ns/assetId" -> v -> builder.assetId(this.transformString((JsonValue)v, context));
            default -> JsonObjectToTransferRequestTransformer.doNothing();
        });
        return builder.build();
    }

    private void transformProperties(JsonValue jsonValue, Consumer<Map<String, Object>> consumer, TransformerContext context) {
        JsonObject jsonObject;
        if (jsonValue instanceof JsonArray) {
            jsonObject = jsonValue.asJsonArray().getJsonObject(0);
        } else if (jsonValue instanceof JsonObject) {
            jsonObject = (JsonObject)jsonValue;
        } else {
            context.problem().unexpectedType().actual((Enum)jsonValue.getValueType()).expected((Enum)JsonValue.ValueType.OBJECT).expected((Enum)JsonValue.ValueType.ARRAY).report();
            return;
        }
        HashMap properties = new HashMap();
        this.visitProperties(jsonObject, (k, v) -> properties.put(k, this.transformString((JsonValue)v, context)));
        consumer.accept(properties);
    }

    @Deprecated(since="0.2.0")
    private void transformStringProperties(JsonValue jsonValue, Consumer<Map<String, String>> consumer, TransformerContext context) {
        JsonObject jsonObject;
        if (jsonValue instanceof JsonArray) {
            jsonObject = jsonValue.asJsonArray().getJsonObject(0);
        } else if (jsonValue instanceof JsonObject) {
            jsonObject = (JsonObject)jsonValue;
        } else {
            context.problem().unexpectedType().actual((Enum)jsonValue.getValueType()).expected((Enum)JsonValue.ValueType.OBJECT).expected((Enum)JsonValue.ValueType.ARRAY).report();
            return;
        }
        HashMap properties = new HashMap();
        this.visitProperties(jsonObject, (k, v) -> properties.put(k, this.transformString((JsonValue)v, context)));
        consumer.accept(properties);
    }
}

