/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.transferprocess;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonCollectors;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.edc.api.model.IdResponse;
import org.eclipse.edc.connector.api.management.transferprocess.TransferProcessApi;
import org.eclipse.edc.connector.api.management.transferprocess.model.TerminateTransfer;
import org.eclipse.edc.connector.api.management.transferprocess.model.TransferState;
import org.eclipse.edc.connector.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.transfer.spi.types.TransferRequest;
import org.eclipse.edc.service.spi.result.ServiceFailure;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v2/transferprocesses")
public class TransferProcessApiController
implements TransferProcessApi {
    private final Monitor monitor;
    private final TransferProcessService service;
    private final TypeTransformerRegistry transformerRegistry;
    private final JsonObjectValidatorRegistry validatorRegistry;

    public TransferProcessApiController(Monitor monitor, TransferProcessService service, TypeTransformerRegistry transformerRegistry, JsonObjectValidatorRegistry validatorRegistry) {
        this.monitor = monitor;
        this.service = service;
        this.transformerRegistry = transformerRegistry;
        this.validatorRegistry = validatorRegistry;
    }

    @Override
    @POST
    @Path(value="request")
    public JsonArray queryTransferProcesses(JsonObject querySpecJson) {
        QuerySpec querySpec;
        if (querySpecJson == null) {
            querySpec = QuerySpec.none();
        } else {
            this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/QuerySpec", querySpecJson).orElseThrow(ValidationFailureException::new);
            querySpec = (QuerySpec)this.transformerRegistry.transform((Object)querySpecJson, QuerySpec.class).orElseThrow(InvalidRequestException::new);
        }
        try (Stream stream = (Stream)this.service.query(querySpec).orElseThrow(ServiceResultHandler.exceptionMapper(TransferProcess.class));){
            JsonArray jsonArray = (JsonArray)stream.map(transferProcess -> (Result)this.transformerRegistry.transform(transferProcess, JsonObject.class).onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]))).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(JsonCollectors.toJsonArray());
            return jsonArray;
        }
    }

    @Override
    @GET
    @Path(value="{id}")
    public JsonObject getTransferProcess(@PathParam(value="id") String id) {
        TransferProcess definition = this.service.findById(id);
        if (definition == null) {
            throw new ObjectNotFoundException(TransferProcess.class, id);
        }
        return (JsonObject)((Result)this.transformerRegistry.transform((Object)definition, JsonObject.class).onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]))).orElseThrow(failure -> new ObjectNotFoundException(TransferProcess.class, id));
    }

    @Override
    @GET
    @Path(value="/{id}/state")
    public JsonObject getTransferProcessState(@PathParam(value="id") String id) {
        return Optional.of(id).map(arg_0 -> ((TransferProcessService)this.service).getState(arg_0)).map(TransferState::new).map(state -> (JsonObject)((Result)this.transformerRegistry.transform(state, JsonObject.class).onFailure(f -> this.monitor.warning(f.getFailureDetail(), new Throwable[0]))).orElseThrow(failure -> new ObjectNotFoundException(TransferProcess.class, id))).orElseThrow(() -> new ObjectNotFoundException(TransferProcess.class, id));
    }

    @Override
    @POST
    public JsonObject initiateTransferProcess(JsonObject request) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/TransferRequest", request).orElseThrow(ValidationFailureException::new);
        TransferRequest transferRequest = (TransferRequest)this.transformerRegistry.transform((Object)request, TransferRequest.class).orElseThrow(InvalidRequestException::new);
        TransferProcess createdTransfer = (TransferProcess)((ServiceResult)this.service.initiateTransfer(transferRequest).onSuccess(d -> this.monitor.debug(String.format("Transfer Process created %s", d.getId()), new Throwable[0]))).orElseThrow(it -> ServiceResultHandler.mapToException((ServiceFailure)it, TransferProcess.class));
        IdResponse responseDto = IdResponse.Builder.newInstance().id(createdTransfer.getId()).createdAt(createdTransfer.getCreatedAt()).build();
        return (JsonObject)this.transformerRegistry.transform((Object)responseDto, JsonObject.class).orElseThrow(f -> new EdcException("Error creating response body: " + f.getFailureDetail()));
    }

    @Override
    @POST
    @Path(value="/{id}/deprovision")
    public void deprovisionTransferProcess(@PathParam(value="id") String id) {
        ((ServiceResult)this.service.deprovision(id).onSuccess(tp -> this.monitor.debug(String.format("Deprovision requested for TransferProcess with ID %s", id), new Throwable[0]))).orElseThrow(ServiceResultHandler.exceptionMapper(TransferProcess.class, (String)id));
    }

    @Override
    @POST
    @Path(value="/{id}/terminate")
    public void terminateTransferProcess(@PathParam(value="id") String id, JsonObject requestBody) {
        this.validatorRegistry.validate("https://w3id.org/edc/v0.0.1/ns/TerminateTransfer", requestBody).orElseThrow(ValidationFailureException::new);
        TerminateTransfer terminateTransfer = (TerminateTransfer)this.transformerRegistry.transform((Object)requestBody, TerminateTransfer.class).orElseThrow(InvalidRequestException::new);
        ((ServiceResult)this.service.terminate(id, terminateTransfer.reason()).onSuccess(tp -> this.monitor.debug(String.format("Termination requested for TransferProcess with ID %s", id), new Throwable[0]))).orElseThrow(failure -> ServiceResultHandler.mapToException((ServiceFailure)failure, TransferProcess.class, (String)id));
    }
}

