/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.transferprocess;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import java.util.Collections;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.transform.JsonObjectFromTransferProcessTransformer;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.transform.JsonObjectFromTransferStateTransformer;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.transform.JsonObjectToSuspendTransferTransformer;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.transform.JsonObjectToTerminateTransferTransformer;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.transform.JsonObjectToTransferRequestTransformer;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.v3.TransferProcessApiV3Controller;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.validation.TerminateTransferValidator;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.validation.TransferRequestValidator;
import org.eclipse.edc.connector.controlplane.services.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transform.spi.TypeTransformer;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Management API: Transfer Process")
public class TransferProcessApiExtension
implements ServiceExtension {
    public static final String NAME = "Management API: Transfer Process";
    @Inject
    private WebService webService;
    @Inject
    private TypeTransformerRegistry transformerRegistry;
    @Inject
    private TransferProcessService service;
    @Inject
    private JsonObjectValidatorRegistry validatorRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonBuilderFactory builderFactory = Json.createBuilderFactory(Collections.emptyMap());
        TypeTransformerRegistry managementApiTransformerRegistry = this.transformerRegistry.forContext("management-api");
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromTransferProcessTransformer(builderFactory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectFromTransferStateTransformer(builderFactory));
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToTerminateTransferTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToSuspendTransferTransformer());
        managementApiTransformerRegistry.register((TypeTransformer)new JsonObjectToTransferRequestTransformer());
        this.validatorRegistry.register("https://w3id.org/edc/v0.0.1/ns/TransferRequest", TransferRequestValidator.instance(context.getMonitor()));
        this.validatorRegistry.register("https://w3id.org/edc/v0.0.1/ns/TerminateTransfer", TerminateTransferValidator.instance());
        this.webService.registerResource("management", (Object)new TransferProcessApiV3Controller(context.getMonitor(), this.service, managementApiTransformerRegistry, this.validatorRegistry));
    }
}

