/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.transferprocess.v2;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.List;
import org.eclipse.edc.api.management.schema.ManagementApiSchema;
import org.eclipse.edc.api.model.ApiCoreSchema;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;

@OpenAPIDefinition(info=@Info(version="v2"))
@Tag(name="Transfer Process V2")
public interface TransferProcessApiV2 {
    public static final String ASYNC_WARNING = "Due to the asynchronous nature of transfers, a successful response only indicates that the request was successfully received. This may take a long time, so clients must poll the /{id}/state endpoint to track the state.";

    @Operation(description="Returns all transfer process according to a query", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=ApiCoreSchema.QuerySpecSchema.class))}), deprecated=true, responses={@ApiResponse(responseCode="200", description="The transfer processes matching the query", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TransferProcessSchema.class)))}), @ApiResponse(responseCode="400", description="Request was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    @Deprecated(since="0.7.0")
    public JsonArray queryTransferProcessesV2(JsonObject var1);

    @Operation(description="Gets an transfer process with the given ID", deprecated=true, responses={@ApiResponse(responseCode="200", description="The transfer process", content={@Content(schema=@Schema(implementation=TransferProcessSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="A transfer process with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    @Deprecated(since="0.7.0")
    public JsonObject getTransferProcessV2(String var1);

    @Operation(description="Gets the state of a transfer process with the given ID", deprecated=true, responses={@ApiResponse(responseCode="200", description="The  transfer process's state", content={@Content(schema=@Schema(implementation=TransferStateSchema.class))}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="An  transfer process with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    @Deprecated(since="0.7.0")
    public JsonObject getTransferProcessStateV2(String var1);

    @Operation(description="Initiates a data transfer with the given parameters. Due to the asynchronous nature of transfers, a successful response only indicates that the request was successfully received. This may take a long time, so clients must poll the /{id}/state endpoint to track the state.", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=TransferRequestSchema.class))}), deprecated=true, responses={@ApiResponse(responseCode="200", description="The transfer was successfully initiated. Returns the transfer process ID and created timestamp", content={@Content(schema=@Schema(implementation=ApiCoreSchema.IdResponseSchema.class))}, links={@Link(name="poll-state", operationId="getTransferProcessStateV2", parameters={@LinkParameter(name="id", expression="$response.body#/id")})}), @ApiResponse(responseCode="400", description="Request body was malformed", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    @Deprecated(since="0.7.0")
    public JsonObject initiateTransferProcessV2(JsonObject var1);

    @Operation(description="Requests the deprovisioning of resources associated with a transfer process. Due to the asynchronous nature of transfers, a successful response only indicates that the request was successfully received. This may take a long time, so clients must poll the /{id}/state endpoint to track the state.", deprecated=true, responses={@ApiResponse(responseCode="204", description="Request to deprovision the transfer process was successfully received", links={@Link(name="poll-state", operationId="deprovisionTransferProcessV2")}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="A transfer process with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    @Deprecated(since="0.7.0")
    public void deprovisionTransferProcessV2(String var1);

    @Operation(description="Requests the termination of a transfer process. Due to the asynchronous nature of transfers, a successful response only indicates that the request was successfully received. This may take a long time, so clients must poll the /{id}/state endpoint to track the state.", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=TerminateTransferSchema.class))}), deprecated=true, responses={@ApiResponse(responseCode="204", description="Request to terminate the transfer process was successfully received", links={@Link(name="poll-state", operationId="terminateTransferProcessV2")}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="A transfer process with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="409", description="Could not terminate transfer process, because it is already completed or terminated.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    @Deprecated(since="0.7.0")
    public void terminateTransferProcessV2(String var1, JsonObject var2);

    @Operation(description="Requests the suspension of a transfer process. Due to the asynchronous nature of transfers, a successful response only indicates that the request was successfully received. This may take a long time, so clients must poll the /{id}/state endpoint to track the state.", requestBody=@RequestBody(content={@Content(schema=@Schema(implementation=SuspendTransferSchema.class))}), deprecated=true, responses={@ApiResponse(responseCode="204", description="Request to suspend the transfer process was successfully received", links={@Link(name="poll-state", operationId="suspendTransferProcessV2")}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="A transfer process with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="409", description="Could not suspend the transfer process, because it is already completed or terminated.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    @Deprecated(since="0.7.0")
    public void suspendTransferProcessV2(String var1, JsonObject var2);

    @Operation(description="Requests the resumption of a suspended transfer process. Due to the asynchronous nature of transfers, a successful response only indicates that the request was successfully received. This may take a long time, so clients must poll the /{id}/state endpoint to track the state.", deprecated=true, responses={@ApiResponse(responseCode="204", description="Request to resume the transfer process was successfully received", links={@Link(name="poll-state", operationId="resumeTransferProcessV2")}), @ApiResponse(responseCode="400", description="Request was malformed, e.g. id was null", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))}), @ApiResponse(responseCode="404", description="A transfer process with the given ID does not exist", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiCoreSchema.ApiErrorDetailSchema.class)))})})
    @Deprecated(since="0.7.0")
    public void resumeTransferProcessV2(String var1);

    @Schema(name="SuspendTransfer", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/SuspendTransfer\",\n    \"reason\": \"a reason to suspend\"\n}\n")
    public record SuspendTransferSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/SuspendTransfer") String ldType, String state) {
        public static final String SUSPEND_TRANSFER_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/SuspendTransfer\",\n    \"reason\": \"a reason to suspend\"\n}\n";
    }

    @Schema(name="TerminateTransfer", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TerminateTransfer\",\n    \"reason\": \"a reason to terminate\"\n}\n")
    public record TerminateTransferSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/TerminateTransfer") String ldType, String state) {
        public static final String TERMINATE_TRANSFER_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TerminateTransfer\",\n    \"reason\": \"a reason to terminate\"\n}\n";
    }

    @Schema(name="TransferState", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TransferState\",\n    \"state\": \"STARTED\"\n}\n")
    public record TransferStateSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/TransferState") String ldType, String state) {
        public static final String TRANSFER_STATE_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TransferState\",\n    \"state\": \"STARTED\"\n}\n";
    }

    @Schema(name="TransferProcess", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TransferProcess\",\n    \"@id\": \"process-id\",\n    \"correlationId\": \"correlation-id\",\n    \"type\": \"PROVIDER\",\n    \"state\": \"STARTED\",\n    \"stateTimestamp\": 1688465655,\n    \"assetId\": \"asset-id\",\n    \"contractId\": \"contractId\",\n    \"dataDestination\": {\n        \"type\": \"data-destination-type\"\n    },\n    \"privateProperties\": {\n        \"private-key\": \"private-value\"\n    },\n    \"errorDetail\": \"eventual-error-detail\",\n    \"createdAt\": 1688465655,\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n")
    public record TransferProcessSchema(@Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/TransferProcess") String ldType, @Schema(name="@id") String id, TransferProcess.Type type, String protocol, String counterPartyId, String counterPartyAddress, String state, String contractAgreementId, String errorDetail, ApiCoreSchema.DataAddressSchema dataDestination, ManagementApiSchema.FreeFormPropertiesSchema privateProperties, List<ManagementApiSchema.CallbackAddressSchema> callbackAddresses) {
        public static final String TRANSFER_PROCESS_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TransferProcess\",\n    \"@id\": \"process-id\",\n    \"correlationId\": \"correlation-id\",\n    \"type\": \"PROVIDER\",\n    \"state\": \"STARTED\",\n    \"stateTimestamp\": 1688465655,\n    \"assetId\": \"asset-id\",\n    \"contractId\": \"contractId\",\n    \"dataDestination\": {\n        \"type\": \"data-destination-type\"\n    },\n    \"privateProperties\": {\n        \"private-key\": \"private-value\"\n    },\n    \"errorDetail\": \"eventual-error-detail\",\n    \"createdAt\": 1688465655,\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n";
    }

    @Schema(name="TransferRequest", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TransferRequest\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"counterPartyAddress\": \"http://provider-address\",\n    \"contractId\": \"contract-id\",\n    \"assetId\": \"asset-id\",\n    \"transferType\": \"transferType\",\n    \"dataDestination\": {\n        \"type\": \"data-destination-type\"\n    },\n    \"privateProperties\": {\n        \"private-key\": \"private-value\"\n    },\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n")
    public record TransferRequestSchema(@Schema(name="@context", requiredMode=Schema.RequiredMode.REQUIRED) Object context, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/TransferRequest") String type, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String protocol, @Deprecated(since="0.3.2") @Schema(deprecated=true, description="please use counterPartyAddress instead") String connectorAddress, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String counterPartyAddress, @Deprecated(since="0.3.2") @Schema(deprecated=true, description="Provider connector id is stored in the contract agreement") String connectorId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String contractId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String assetId, @Schema(requiredMode=Schema.RequiredMode.REQUIRED) String transferType, ApiCoreSchema.DataAddressSchema dataDestination, @Schema(additionalProperties=Schema.AdditionalPropertiesValue.TRUE) ManagementApiSchema.FreeFormPropertiesSchema privateProperties, List<ManagementApiSchema.CallbackAddressSchema> callbackAddresses) {
        public static final String TRANSFER_REQUEST_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/TransferRequest\",\n    \"protocol\": \"dataspace-protocol-http\",\n    \"counterPartyAddress\": \"http://provider-address\",\n    \"contractId\": \"contract-id\",\n    \"assetId\": \"asset-id\",\n    \"transferType\": \"transferType\",\n    \"dataDestination\": {\n        \"type\": \"data-destination-type\"\n    },\n    \"privateProperties\": {\n        \"private-key\": \"private-value\"\n    },\n    \"callbackAddresses\": [{\n        \"transactional\": false,\n        \"uri\": \"http://callback/url\",\n        \"events\": [\"contract.negotiation\", \"transfer.process\"],\n        \"authKey\": \"auth-key\",\n        \"authCodeId\": \"auth-code-id\"\n    }]\n}\n";
    }
}

