/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.transferprocess.v3;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.BaseTransferProcessApiController;
import org.eclipse.edc.connector.controlplane.api.management.transferprocess.v3.TransferProcessApiV3;
import org.eclipse.edc.connector.controlplane.services.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v3/transferprocesses")
public class TransferProcessApiV3Controller
extends BaseTransferProcessApiController
implements TransferProcessApiV3 {
    public TransferProcessApiV3Controller(Monitor monitor, TransferProcessService service, TypeTransformerRegistry transformerRegistry, JsonObjectValidatorRegistry validatorRegistry) {
        super(monitor, service, transformerRegistry, validatorRegistry);
    }

    @Override
    @POST
    @Path(value="request")
    public JsonArray queryTransferProcessesV3(JsonObject querySpecJson) {
        return this.queryTransferProcesses(querySpecJson);
    }

    @Override
    @GET
    @Path(value="{id}")
    public JsonObject getTransferProcessV3(@PathParam(value="id") String id) {
        return this.getTransferProcess(id);
    }

    @Override
    @GET
    @Path(value="/{id}/state")
    public JsonObject getTransferProcessStateV3(@PathParam(value="id") String id) {
        return this.getTransferProcessState(id);
    }

    @Override
    @POST
    public JsonObject initiateTransferProcessV3(JsonObject transferRequest) {
        return this.initiateTransferProcess(transferRequest);
    }

    @Override
    @POST
    @Path(value="/{id}/deprovision")
    public void deprovisionTransferProcessV3(@PathParam(value="id") String id) {
        this.deprovisionTransferProcess(id);
    }

    @Override
    @POST
    @Path(value="/{id}/terminate")
    public void terminateTransferProcessV3(@PathParam(value="id") String id, JsonObject terminateTransfer) {
        this.terminateTransferProcess(id, terminateTransfer);
    }

    @Override
    @POST
    @Path(value="/{id}/suspend")
    public void suspendTransferProcessV3(@PathParam(value="id") String id, JsonObject suspendTransfer) {
        this.suspendTransferProcess(id, suspendTransfer);
    }

    @Override
    @POST
    @Path(value="/{id}/resume")
    public void resumeTransferProcessV3(@PathParam(value="id") String id) {
        this.resumeTransferProcess(id);
    }
}

