/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.management.transferprocess.transform;

import jakarta.json.JsonArray;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonCollectors;
import java.util.Optional;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcessStates;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromTransferProcessTransformer
extends AbstractJsonLdTransformer<TransferProcess, JsonObject> {
    private final JsonBuilderFactory builderFactory;

    public JsonObjectFromTransferProcessTransformer(JsonBuilderFactory builderFactory) {
        super(TransferProcess.class, JsonObject.class);
        this.builderFactory = builderFactory;
    }

    @Nullable
    public JsonObject transform(@NotNull TransferProcess input, @NotNull TransformerContext context) {
        JsonArray callbackAddresses = (JsonArray)input.getCallbackAddresses().stream().map(it -> (JsonObject)context.transform(it, JsonObject.class)).collect(JsonCollectors.toJsonArray());
        JsonObjectBuilder builder = this.builderFactory.createObjectBuilder().add("@id", input.getId()).add("@type", "https://w3id.org/edc/v0.0.1/ns/TransferProcess").add("https://w3id.org/edc/v0.0.1/ns/state", TransferProcessStates.from((int)input.getState()).name()).add("https://w3id.org/edc/v0.0.1/ns/stateTimestamp", input.getStateTimestamp()).add("https://w3id.org/edc/v0.0.1/ns/type", input.getType().name()).add("https://w3id.org/edc/v0.0.1/ns/callbackAddresses", (JsonValue)callbackAddresses);
        this.addIfNotNull(input.getCorrelationId(), "https://w3id.org/edc/v0.0.1/ns/correlationId", builder);
        this.addIfNotNull(input.getAssetId(), "https://w3id.org/edc/v0.0.1/ns/assetId", builder);
        this.addIfNotNull(input.getContractId(), "https://w3id.org/edc/v0.0.1/ns/contractId", builder);
        this.addIfNotNull(input.getTransferType(), "https://w3id.org/edc/v0.0.1/ns/transferType", builder);
        this.addIfNotNull(input.getErrorDetail(), "https://w3id.org/edc/v0.0.1/ns/errorDetail", builder);
        Optional.ofNullable(input.getDataDestination()).map(it -> (JsonObject)context.transform(it, JsonObject.class)).ifPresent(it -> builder.add("https://w3id.org/edc/v0.0.1/ns/dataDestination", (JsonValue)it));
        return builder.build();
    }
}

