/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.transferprocess.transform;

import java.util.Objects;
import java.util.UUID;
import org.eclipse.edc.api.transformer.DtoTransformer;
import org.eclipse.edc.connector.api.management.transferprocess.model.TransferRequestDto;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferRequestDtoToDataRequestTransformer
implements DtoTransformer<TransferRequestDto, DataRequest> {
    public Class<TransferRequestDto> getInputType() {
        return TransferRequestDto.class;
    }

    public Class<DataRequest> getOutputType() {
        return DataRequest.class;
    }

    @Nullable
    public DataRequest transform(@NotNull TransferRequestDto object, @NotNull TransformerContext context) {
        String id = Objects.requireNonNullElseGet(object.getId(), () -> UUID.randomUUID().toString());
        return DataRequest.Builder.newInstance().id(id).assetId(object.getAssetId()).connectorId(object.getConnectorId()).dataDestination(object.getDataDestination()).connectorAddress(object.getConnectorAddress()).contractId(object.getContractId()).transferType(object.getTransferType()).destinationType(object.getDataDestination().getType()).properties(object.getProperties()).managedResources(object.isManagedResources()).protocol(object.getProtocol()).dataDestination(object.getDataDestination()).build();
    }
}

