/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.transferprocess.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edc.connector.transfer.spi.types.TransferType;
import org.eclipse.edc.spi.types.domain.DataAddress;

@JsonDeserialize(builder=Builder.class)
public class TransferRequestDto {
    private String id;
    @NotNull(message="connectorAddress cannot be null")
    private @NotNull(message="connectorAddress cannot be null") String connectorAddress;
    @NotNull(message="contractId cannot be null")
    private @NotNull(message="contractId cannot be null") String contractId;
    @NotNull(message="dataDestination cannot be null")
    private @NotNull(message="dataDestination cannot be null") DataAddress dataDestination;
    private boolean managedResources = true;
    private Map<String, String> properties = new HashMap<String, String>();
    @NotNull(message="transferType cannot be null")
    private @NotNull(message="transferType cannot be null") TransferType transferType = new TransferType();
    @NotNull(message="protocol cannot be null")
    private @NotNull(message="protocol cannot be null") String protocol = "ids-multipart";
    @NotNull(message="connectorId cannot be null")
    private @NotNull(message="connectorId cannot be null") String connectorId;
    @NotNull(message="assetId cannot be null")
    private @NotNull(message="assetId cannot be null") String assetId;

    public String getConnectorAddress() {
        return this.connectorAddress;
    }

    public String getId() {
        return this.id;
    }

    public String getContractId() {
        return this.contractId;
    }

    public DataAddress getDataDestination() {
        return this.dataDestination;
    }

    public boolean isManagedResources() {
        return this.managedResources;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private final TransferRequestDto request = new TransferRequestDto();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder connectorAddress(String connectorAddress) {
            this.request.connectorAddress = connectorAddress;
            return this;
        }

        public Builder id(String id) {
            this.request.id = id;
            return this;
        }

        public Builder contractId(String contractId) {
            this.request.contractId = contractId;
            return this;
        }

        public Builder dataDestination(DataAddress dataDestination) {
            this.request.dataDestination = dataDestination;
            return this;
        }

        public Builder managedResources(boolean managedResources) {
            this.request.managedResources = managedResources;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.request.properties = properties;
            return this;
        }

        public Builder transferType(TransferType transferType) {
            this.request.transferType = transferType;
            return this;
        }

        public Builder protocol(String protocol) {
            this.request.protocol = protocol;
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.request.connectorId = connectorId;
            return this;
        }

        public Builder assetId(String assetId) {
            this.request.assetId = assetId;
            return this;
        }

        public TransferRequestDto build() {
            return this.request;
        }
    }
}

