/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.transferprocess;

import jakarta.validation.Valid;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.api.model.IdResponseDto;
import org.eclipse.edc.api.query.QuerySpecDto;
import org.eclipse.edc.api.transformer.DtoTransformerRegistry;
import org.eclipse.edc.connector.api.management.transferprocess.TransferProcessApi;
import org.eclipse.edc.connector.api.management.transferprocess.model.TransferProcessDto;
import org.eclipse.edc.connector.api.management.transferprocess.model.TransferRequestDto;
import org.eclipse.edc.connector.api.management.transferprocess.model.TransferState;
import org.eclipse.edc.connector.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="/transferprocess")
public class TransferProcessApiController
implements TransferProcessApi {
    private final Monitor monitor;
    private final TransferProcessService service;
    private final DtoTransformerRegistry transformerRegistry;

    public TransferProcessApiController(Monitor monitor, TransferProcessService service, DtoTransformerRegistry transformerRegistry) {
        this.monitor = monitor;
        this.service = service;
        this.transformerRegistry = transformerRegistry;
    }

    @Override
    @POST
    @Path(value="/request")
    public List<TransferProcessDto> queryAllTransferProcesses(@Valid QuerySpecDto querySpecDto) {
        return this.queryTransferProcesses(Optional.ofNullable(querySpecDto).orElse(QuerySpecDto.Builder.newInstance().build()));
    }

    @Override
    @GET
    @Deprecated
    public List<TransferProcessDto> getAllTransferProcesses(@Valid @BeanParam QuerySpecDto querySpecDto) {
        return this.queryTransferProcesses(querySpecDto);
    }

    @Override
    @GET
    @Path(value="/{id}")
    public TransferProcessDto getTransferProcess(@PathParam(value="id") String id) {
        return Optional.of(id).map(arg_0 -> ((TransferProcessService)this.service).findById(arg_0)).map(it -> this.transformerRegistry.transform(it, TransferProcessDto.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).orElseThrow(() -> new ObjectNotFoundException(TransferProcess.class, id));
    }

    @Override
    @GET
    @Path(value="/{id}/state")
    public TransferState getTransferProcessState(@PathParam(value="id") String id) {
        return Optional.of(id).map(arg_0 -> ((TransferProcessService)this.service).getState(arg_0)).map(TransferState::new).orElseThrow(() -> new ObjectNotFoundException(TransferProcess.class, id));
    }

    @Override
    @POST
    @Path(value="/{id}/cancel")
    public void cancelTransferProcess(@PathParam(value="id") String id) {
        this.monitor.debug("Cancelling TransferProcess with ID " + id, new Throwable[0]);
        TransferProcess transferProcess = (TransferProcess)this.service.cancel(id).orElseThrow(ServiceResultHandler.exceptionMapper(TransferProcess.class, (String)id));
        this.monitor.debug(String.format("Transfer process canceled %s", transferProcess.getId()), new Throwable[0]);
    }

    @Override
    @POST
    @Path(value="/{id}/deprovision")
    public void deprovisionTransferProcess(@PathParam(value="id") String id) {
        this.monitor.debug(String.format("Attempting to deprovision TransferProcess with id %s", id), new Throwable[0]);
        TransferProcess transferProcess = (TransferProcess)this.service.deprovision(id).orElseThrow(ServiceResultHandler.exceptionMapper(TransferProcess.class, (String)id));
        this.monitor.debug(String.format("Transfer process deprovisioned %s", transferProcess.getId()), new Throwable[0]);
    }

    @Override
    @POST
    public IdResponseDto initiateTransfer(@Valid TransferRequestDto transferRequest) {
        Result transformResult = this.transformerRegistry.transform((Object)transferRequest, DataRequest.class);
        if (transformResult.failed()) {
            throw new InvalidRequestException(transformResult.getFailureMessages());
        }
        this.monitor.debug("Starting transfer for asset " + transferRequest.getAssetId(), new Throwable[0]);
        DataRequest dataRequest = (DataRequest)transformResult.getContent();
        String result = (String)this.service.initiateTransfer(dataRequest).orElseThrow(ServiceResultHandler.exceptionMapper(TransferProcess.class, (String)transferRequest.getId()));
        return (IdResponseDto)((IdResponseDto.Builder)IdResponseDto.Builder.newInstance().id(result).createdAt(Clock.systemUTC().millis())).build();
    }

    private List<TransferProcessDto> queryTransferProcesses(QuerySpecDto querySpecDto) {
        Result result = this.transformerRegistry.transform((Object)querySpecDto, QuerySpec.class);
        if (result.failed()) {
            throw new InvalidRequestException(result.getFailureMessages());
        }
        QuerySpec spec = (QuerySpec)result.getContent();
        try (Stream stream = (Stream)this.service.query(spec).orElseThrow(ServiceResultHandler.exceptionMapper(TransferProcess.class, null));){
            List<TransferProcessDto> list = stream.map(tp -> this.transformerRegistry.transform(tp, TransferProcessDto.class)).filter(AbstractResult::succeeded).map(AbstractResult::getContent).collect(Collectors.toList());
            return list;
        }
    }
}

