/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.token.rules;

import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotBeforeValidationRule
implements TokenValidationRule {
    private final Clock clock;
    private final int notBeforeLeeway;
    private final boolean allowNull;

    public NotBeforeValidationRule(Clock clock, int notBeforeLeeway, boolean allowNull) {
        this.clock = clock;
        this.notBeforeLeeway = notBeforeLeeway;
        this.allowNull = allowNull;
    }

    public Result<Void> checkRule(@NotNull ClaimToken toVerify, @Nullable Map<String, Object> additional) {
        Instant now = this.clock.instant();
        Instant leewayNow = now.plusSeconds(this.notBeforeLeeway);
        Instant notBefore = toVerify.getInstantClaim("nbf");
        if (notBefore == null) {
            if (!this.allowNull) {
                return Result.failure((String)"Required not before (nbf) claim is missing in token");
            }
        } else if (leewayNow.isBefore(notBefore)) {
            return Result.failure((String)"Current date/time with leeway before the not before (nbf) claim in token");
        }
        return Result.success();
    }
}

