/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.token.rules;

import java.util.List;
import java.util.Map;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AudienceValidationRule
implements TokenValidationRule {
    private final String expectedAudience;

    public AudienceValidationRule(String expectedAudience) {
        this.expectedAudience = expectedAudience;
    }

    public Result<Void> checkRule(@NotNull ClaimToken toVerify, @Nullable Map<String, Object> additional) {
        List audiences = toVerify.getListClaim("aud");
        if (audiences.isEmpty()) {
            return Result.failure((String)"Required audience (aud) claim is missing in token");
        }
        if (!audiences.contains(this.expectedAudience)) {
            return Result.failure((String)"Token audience claim (aud -> %s) did not contain expected audience: %s".formatted(audiences.stream().map(Object::toString).toList(), this.expectedAudience));
        }
        return Result.success();
    }
}

