/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.token.rules;

import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpirationIssuedAtValidationRule
implements TokenValidationRule {
    private final Clock clock;
    private final int issuedAtLeeway;
    private final boolean allowNull;

    @Deprecated(since="0.7.0")
    public ExpirationIssuedAtValidationRule(Clock clock, int issuedAtLeeway) {
        this(clock, issuedAtLeeway, false);
    }

    public ExpirationIssuedAtValidationRule(Clock clock, int issuedAtLeeway, boolean allowNull) {
        this.clock = clock;
        this.issuedAtLeeway = issuedAtLeeway;
        this.allowNull = allowNull;
    }

    public Result<Void> checkRule(@NotNull ClaimToken toVerify, @Nullable Map<String, Object> additional) {
        Instant issuedAt;
        Instant now = this.clock.instant();
        Instant expires = toVerify.getInstantClaim("exp");
        if (expires == null) {
            if (!this.allowNull) {
                return Result.failure((String)"Required expiration time (exp) claim is missing in token");
            }
        } else if (now.isAfter(expires)) {
            return Result.failure((String)"Token has expired (exp)");
        }
        if ((issuedAt = toVerify.getInstantClaim("iat")) != null) {
            if (issuedAt.isAfter(expires)) {
                return Result.failure((String)"Issued at (iat) claim is after expiration time (exp) claim in token");
            }
            if (now.plusSeconds(this.issuedAtLeeway).isBefore(issuedAt)) {
                return Result.failure((String)"Current date/time before issued at (iat) claim in token");
            }
        }
        return Result.success();
    }
}

