/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.token;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.eclipse.edc.keys.spi.PublicKeyResolver;
import org.eclipse.edc.security.token.jwt.CryptoConverter;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.eclipse.edc.token.spi.TokenValidationService;

public class TokenValidationServiceImpl
implements TokenValidationService {
    public Result<ClaimToken> validate(TokenRepresentation tokenRepresentation, PublicKeyResolver publicKeyResolver, List<TokenValidationRule> rules) {
        String token = tokenRepresentation.getToken();
        Map additional = tokenRepresentation.getAdditional();
        try {
            SignedJWT signedJwt = SignedJWT.parse((String)token);
            String publicKeyId = signedJwt.getHeader().getKeyID();
            Result publicKeyResolutionResult = publicKeyResolver.resolveKey(publicKeyId);
            if (publicKeyResolutionResult.failed()) {
                return (Result)publicKeyResolutionResult.mapFailure();
            }
            JWSVerifier verifierCreationResult = CryptoConverter.createVerifierFor((PublicKey)((PublicKey)publicKeyResolutionResult.getContent()));
            if (!signedJwt.verify(verifierCreationResult)) {
                return Result.failure((String)"Token verification failed");
            }
            ClaimToken.Builder tokenBuilder = ClaimToken.Builder.newInstance();
            signedJwt.getJWTClaimsSet().getClaims().entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> tokenBuilder.claim((String)entry.getKey(), entry.getValue()));
            ClaimToken claimToken = tokenBuilder.build();
            List errors = rules.stream().map(r -> r.checkRule(claimToken, additional)).reduce(Result::merge).stream().filter(AbstractResult::failed).flatMap(r -> r.getFailureMessages().stream()).toList();
            if (!errors.isEmpty()) {
                return Result.failure(errors);
            }
            return Result.success((Object)claimToken);
        }
        catch (JOSEException e) {
            return Result.failure((String)e.getMessage());
        }
        catch (ParseException e) {
            return Result.failure((String)"Failed to decode token");
        }
    }
}

