/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.token;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.edc.token.spi.TokenDecorator;
import org.eclipse.edc.token.spi.TokenDecoratorRegistry;

public class TokenDecoratorRegistryImpl
implements TokenDecoratorRegistry {
    private final Map<String, List<TokenDecorator>> decorators = new HashMap<String, List<TokenDecorator>>();

    public void register(String context, TokenDecorator decorator) {
        this.decorators.computeIfAbsent(context, s -> new ArrayList()).add(decorator);
    }

    public void unregister(String context, TokenDecorator decorator) {
        if (this.decorators.containsKey(context)) {
            this.decorators.get(context).remove(decorator);
        }
    }

    public Collection<TokenDecorator> getDecoratorsFor(String context) {
        return Optional.ofNullable(this.decorators.get(context)).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
    }
}

