/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.token;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.edc.jwt.signer.spi.JwsSignerProvider;
import org.eclipse.edc.security.token.jwt.CryptoConverter;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.iam.TokenParameters;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenDecorator;
import org.eclipse.edc.token.spi.TokenGenerationService;

public class JwtGenerationService
implements TokenGenerationService {
    private final JwsSignerProvider jwsGeneratorFunction;

    public JwtGenerationService(JwsSignerProvider jwsSignerProvider) {
        this.jwsGeneratorFunction = jwsSignerProvider;
    }

    public Result<TokenRepresentation> generate(String privateKeyId, TokenDecorator ... decorators) {
        Result tokenSignerResult = this.jwsGeneratorFunction.createJwsSigner(privateKeyId);
        if (tokenSignerResult.failed()) {
            return Result.failure((String)"JWSSigner cannot be generated for private key '%s': %s".formatted(privateKeyId, tokenSignerResult.getFailureDetail()));
        }
        JWSSigner tokenSigner = (JWSSigner)tokenSignerResult.getContent();
        JWSAlgorithm jwsAlgorithm = CryptoConverter.getRecommendedAlgorithm((JWSSigner)tokenSigner);
        TokenParameters.Builder bldr = TokenParameters.Builder.newInstance();
        ArrayList<TokenDecorator> allDecorators = new ArrayList<TokenDecorator>(Arrays.asList(decorators));
        allDecorators.add(new BaseDecorator(jwsAlgorithm));
        allDecorators.forEach(td -> td.decorate(bldr));
        TokenParameters tokenParams = bldr.build();
        JWSHeader jwsHeader = this.createHeader(tokenParams.getHeaders());
        JWTClaimsSet claimsSet = this.createClaimsSet(tokenParams.getClaims());
        SignedJWT token = new SignedJWT(jwsHeader, claimsSet);
        try {
            token.sign(tokenSigner);
        }
        catch (JOSEException e) {
            return Result.failure((String)("Failed to sign token: " + e.getMessage()));
        }
        return Result.success((Object)TokenRepresentation.Builder.newInstance().token(token.serialize()).build());
    }

    private JWSHeader createHeader(Map<String, Object> headers) {
        try {
            return JWSHeader.parse(headers);
        }
        catch (ParseException e) {
            throw new EdcException("Error parsing JWSHeader, this should never happens since the algorithm is always valid", (Throwable)e);
        }
    }

    private JWTClaimsSet createClaimsSet(Map<String, Object> claims) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        claims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        return builder.build();
    }

    private record BaseDecorator(JWSAlgorithm jwsAlgorithm) implements TokenDecorator
    {
        public TokenParameters.Builder decorate(TokenParameters.Builder tokenParameters) {
            return tokenParameters.header("alg", (Object)this.jwsAlgorithm.getName());
        }
    }
}

