/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.token;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.edc.jwt.validation.jti.JtiValidationEntry;
import org.eclipse.edc.jwt.validation.jti.JtiValidationStore;
import org.eclipse.edc.spi.result.StoreResult;

public class InMemoryJtiValidationStore
implements JtiValidationStore {
    private final Map<String, JtiValidationEntry> jtiValidationEntries = new ConcurrentHashMap<String, JtiValidationEntry>();

    public StoreResult<Void> storeEntry(JtiValidationEntry entry) {
        if (this.jtiValidationEntries.containsKey(entry.tokenId())) {
            return StoreResult.alreadyExists((String)"JTI Validation Entry with ID '%s' already exists".formatted(entry.tokenId()));
        }
        this.jtiValidationEntries.put(entry.tokenId(), entry);
        return StoreResult.success();
    }

    public JtiValidationEntry findById(String id, boolean autoRemove) {
        return autoRemove ? this.jtiValidationEntries.remove(id) : this.jtiValidationEntries.get(id);
    }

    public StoreResult<Void> deleteById(String id) {
        return this.jtiValidationEntries.remove(id) == null ? StoreResult.notFound((String)"JTI Validation Entry with ID '%s' not found".formatted(id)) : StoreResult.success();
    }

    public StoreResult<Integer> deleteExpired() {
        long count = this.jtiValidationEntries.values().stream().filter(JtiValidationEntry::isExpired).count();
        this.jtiValidationEntries.values().removeIf(JtiValidationEntry::isExpired);
        return StoreResult.success((Object)((int)count));
    }
}

